<?php
	/**
	 * Medodove Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Medodove/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'dogri_download_widget');
	function dogri_download_widget() {
		register_widget('dogri_download_widget');
	}
	
	
	class Dogri_Download_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('dogri_download_widget',esc_html__('Dogri Download Widget','dogri-toolkit'),array(
				'description' => esc_html__('Dogri Download Widget','dogri-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 


		?>       


		<div class="footer-widget footer-col-1">
				<div class="footer-logo mb-35">
				<?php 
					if( $logo_url ): ?>
					<a href="<?php  print home_url(); ?>"><img src="<?php echo esc_url( $logo_url ); ?>" alt="Footer Logo" /></a>
				<?php 
					endif; ?>
				</div>
				<p><?php echo wp_kses_post( $title ); ?>
				</p>
			</div>
			<div class="footer__opening d-flex align-items-start">
				<div class="footer-opening-icon mr-15">
				<span>
					<svg width="36" height="33" viewBox="0 0 36 33" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<path
							d="M33.3525 8.27969L28.1441 29.1907C27.7732 30.7516 26.3823 31.8335 24.7749 31.8335H4.4667C2.13296 31.8335 0.463822 29.546 1.1593 27.305L7.66595 6.40966C8.11415 4.95687 9.45877 3.95215 10.9734 3.95215H29.9833C31.4516 3.95215 32.6725 4.84856 33.1826 6.08498C33.4762 6.74955 33.538 7.50692 33.3525 8.27969Z"
							stroke="#EB753B" stroke-width="2" stroke-miterlimit="10" />
						<path
							d="M24.1895 31.8329H31.5771C33.5708 31.8329 35.1318 30.1482 34.9927 28.1545L33.4626 7.10449"
							stroke="#EB753B" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"
							stroke-linejoin="round" />
						<path d="M14.4199 7.69318L16.0273 1.0166" stroke="#EB753B" stroke-width="2"
							stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
						<path d="M24.7734 7.70752L26.2262 1" stroke="#EB753B" stroke-width="2"
							stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
						<path d="M11.3594 16.3779H23.7236" stroke="#EB753B" stroke-width="2"
							stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
						<path d="M9.81445 22.5596H22.1787" stroke="#EB753B" stroke-width="2"
							stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
					</svg>
				</span>
				</div>
				<div class="footer-opening-content">
				<h4><?php echo wp_kses_post( $title_2 ); ?></h4>
				<p><?php echo wp_kses_post( $address ); ?></p>
				</div>
			</div>




	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$title_2  = isset($instance['title_2'])? $instance['title_2']:'';
			$subscribe_style  = isset($instance['subscribe_style'])? $instance['subscribe_style'] : 'style_1';
			$logo_url  = isset($instance['logo_url'])? $instance['logo_url']:'';
			$address  = isset($instance['address'])? $instance['address']:'';		
			?>

			<p>
				<label for="logo_url"><?php esc_html_e('Logo Url:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('logo_url')); ?>"  name="<?php print esc_attr($this->get_field_name('logo_url')); ?>" value="<?php print esc_attr($logo_url); ?>">
			<p>
				<label for="title"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">				

			<p>
				<label for="title_2"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title_2')); ?>"  name="<?php print esc_attr($this->get_field_name('title_2')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="address"><?php esc_html_e('Time:','dogri-toolkit'); ?></label>
			</p>

			<textarea class="widefat" rows="2" cols="15" id="<?php print esc_attr($this->get_field_id('address')); ?>" value="<?php print esc_attr($address); ?>" name="<?php print esc_attr($this->get_field_name('address')); ?>"><?php print esc_attr($address); ?></textarea>
			
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['title_2'] = ( ! empty( $new_instance['title_2'] ) ) ? strip_tags( $new_instance['title_2'] ) : '';
			$instance['subscribe_style'] = ( ! empty( $new_instance['subscribe_style'] ) ) ? strip_tags( $new_instance['subscribe_style'] ) : '';
			$instance['logo_url'] = ( ! empty( $new_instance['logo_url'] ) ) ? strip_tags( $new_instance['logo_url'] ) : '';
			$instance['address'] = ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';

			
			return $instance;
		}
	}