<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Dogri_Service_Post_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Dogri Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'dogri_service_post_widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Dogri Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Post Services', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Dogri Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Dogri Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}

	public function get_keywords() {
		return [ 'service-post' ];
	}

	public function get_script_depends() {
		return [ 'dogri-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Section Heading', 'dogri-elementor' ),
			]
		);
		$this->add_control(
			'sub_heading',
			[
				'label'       => __( 'Sub Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your prefix Heading', 'dogri-elementor' ),
				'default'     => __( 'Awesome Features', 'dogri-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'dogri-elementor' ),
				'default'     => __( 'It is Heading', 'dogri-elementor' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'desc',
			[
				'label'       => __( 'Description', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your heading', 'dogri-elementor' ),
				'default'     => __( 'It is Description', 'dogri-elementor' ),
				'label_block' => true,
				'condition' => [
					'chose_style' => ['service-style-2']
				],
			]
		);

		$this->add_control(
            'background_bg_color',
            [
                'label' => __( 'Background Color', 'dogri-elementor' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .el-services-area' => 'background-color: {{VALUE}};',
				],				
				'condition' => [
					'chose_style' => ['service-style-2']
				],
            ]
        );


		$this->add_control(
			'text',
			[
				'label'       => __( 'Description Text', 'theme-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description', 'theme-elementor' ),
			]
		);

		$this->add_control(
			'bttn',
			[
				'label'       => __( 'Button', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Enter your Button Title', 'dogri-elementor' ),
				'default' => esc_html__('Read More', 'dogri-elementor'),
			]
		);	


		$this->add_control(
				'btnlink',
				[
				'label' => __( 'Button Url', 'dogri-elementor' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				
			]
			);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_service_post',
			[
				'label' => esc_html__( 'Section Service Post', 'dogri-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'service-style-1'  => esc_html__( 'Service Style 1', 'dogri-elementor' ),
					'service-style-2' => esc_html__( 'Service Style 2', 'dogri-elementor' ),
					'service-style-3' => esc_html__( 'Service Style 3', 'dogri-elementor' ),
				],
				'default'   => 'service-style-1',
			]
		);

		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'dogri-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'content_word_count',
			[
				'label'       => __( 'Content Word Count', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'dogri-elementor' ),
				'default'   => 15,				
			]
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'dogri-elementor' ),
					'2'  => esc_html__( '2', 'dogri-elementor' ),
					'3'  => esc_html__( '3', 'dogri-elementor' ),
					'4'  => esc_html__( '4', 'dogri-elementor' ),
					'5'  => esc_html__( '5', 'dogri-elementor' ),
					'6' => esc_html__( '6', 'dogri-elementor' ),
					'7' => esc_html__( '7', 'dogri-elementor' ),
					'8' => esc_html__( '8', 'dogri-elementor' ),
					'9' => esc_html__( '9', 'dogri-elementor' ),
					'10' => esc_html__( '10', 'dogri-elementor' ),
					'-1' => esc_html__( 'Show All', 'dogri-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'dogri-elementor' ),
					'title'  => esc_html__( 'Title', 'dogri-elementor' ),
					'date' => esc_html__( 'Date', 'dogri-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'dogri-elementor' ),
					'rand' => esc_html__( 'Random Order', 'dogri-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'dogri-elementor' ),
				],
				'default'   => 'ID',
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Post Order', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'dogri-elementor' ),
					'desc' => esc_html__( 'DESC', 'dogri-elementor' ),
				],
				'default'   => 'desc',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Category Slug', 'dogri-elementor' ),
				'label_block' => true,				
			]
		);		


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'dogri-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'dogri-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_sub_heading',
			[
				'label'   => esc_html__( 'Show Sub Heading', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_desc',
			[
				'label'   => esc_html__( 'Show Description', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->end_controls_section();



		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
	
		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .service-area .section-subtitle span' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .service-area .section-subtitle' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .service-area .section-subtitle span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .service-area .section-subtitle span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-6' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
		
			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .service-area .section-subtitle span',
				'selector' => '{{WRAPPER}} .section-subtitle-5',
				'selector' => '{{WRAPPER}} .section-subtitle-6',
			)
		);
		
		
		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-area .section-subtitle span' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-area .section-subtitle span' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-6' => 'background-color: {{VALUE}} !important',
				),
			
			)
		); 

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .service-area .section-title' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .service-area .section-title' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .service-area .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-subtitle-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .service-area .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-subtitle-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .service-area .section-title',
				'selector' => '{{WRAPPER}} .section-subtitle-5',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-area .section-title' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	


		// Title 	==================	


		$this->start_controls_section(
			'title_settings',
			array(
				'label' => __( 'Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
				
		$this->add_control(
			'show_title',
			array(
				'label' => esc_html__( 'Show Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .service-content h4' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .service-content-4 h3' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .what-we-do-content h4' => 'display: {{VALUE}} !important',
				),   
			)
		);
		
		$this->add_control(
			'title_alignment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .service-content h4' => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .service-content-4 h3' => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .what-we-do-content h4' => 'text-align: {{VALUE}}',
				),
			)
		);
		
		$this->add_control(
			'title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .service-content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .service-content-4 h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .what-we-do-content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .service-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .service-content-4 h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .what-we-do-content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'condition'    => array( 'show_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .service-content h4',
				'selector' => '{{WRAPPER}} .service-content-4 h3',
				'selector' => '{{WRAPPER}} .what-we-do-content h4',
			)
		);
		
		$this->add_control(
			'title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-content h4' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .service-content-4 h3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .what-we-do-content h4' => 'color: {{VALUE}} !important',
		
				),
			)
		);

		$this->add_control(
			'title_hover_color',
			array(
				'label'     => __( 'Hover Color', 'dogri-elementor' ),
				'condition'    => array( 'show_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .service-content h4:hover' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .service-content-4 h3:hover' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .what-we-do-content h4:hover' => 'color: {{VALUE}} !important',
		
				),
			)
		);

		$this->end_controls_section();	
		
		
		//End of  Title 	==================



		//Sub Title	==================	


	$this->start_controls_section(
		'subtitle_settings',
		array(
			'label' => __( 'Sub Title Setting', 'dogri-elementor' ),
		
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

$this->add_control(
		'show_subtitle',
		array(
			'label' => esc_html__( 'Show Sub Title', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .service-content p' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .service-content-4 p' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .what-we-do-content p' => 'display: {{VALUE}} !important',
			),  
		)
	);	
$this->add_control(
		'subtitle_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_subtitle' => 'show' ),
			'toggle' => true,
			'selectors' => array(
			
				'{{WRAPPER}} .service-content p' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .service-content-4 p' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .what-we-do-content p' => 'text-align: {{VALUE}} !important',
			),
		)
	);	
$this->add_control(
		'subtitle_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'condition'    => array( 'show_subtitle' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
		'{{WRAPPER}} .service-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .service-content-4 p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .what-we-do-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			),
		)
	);
	$this->add_control(
		'subtitle_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'condition'    => array( 'show_subtitle' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
		'{{WRAPPER}} .service-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .service-content-4 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .what-we-do-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			),
		)
	);
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
	
		array(
			'name'     => 'subtitle_typography',
			'condition'    => array( 'show_subtitle' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .service-content p',
			'selector' => '{{WRAPPER}} .service-content-4 p',
			'selector' => '{{WRAPPER}} .what-we-do-content p',
		)
	);
	
	
	$this->add_control(
		'subtitle_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_subtitle' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-content p' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .service-content-4 p' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .what-we-do-content p' => 'color: {{VALUE}} !important',
			),
		
		)
	);

	$this->add_control(
		'subtitle_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_subtitle' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-content p' => 'background-color: {{VALUE}} !important',
				'{{WRAPPER}} .service-content-4 p' => 'background-color: {{VALUE}} !important',
				'{{WRAPPER}} .what-we-do-content p' => 'background-color: {{VALUE}} !important',
			),
		
		)
	);

	$this->end_controls_section();
	
	//End of  Sub Title 	==================	

	//========== icon Settings===================================
		
	$this->start_controls_section(
		'icon_control',
		array(
			'label' => __( 'Icon Settings', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'show_icon',
		array(
			'label' => esc_html__( 'Show Icon', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .service-link-2 a' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .what-we-do-icon span' => 'display: {{VALUE}} !important',
			),
		)
	);
	
	
	
	$this->add_control(
		'icon_bgcolor',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_icon' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-link-2 a' => 'background: {{VALUE}} !important',
				'{{WRAPPER}} .what-we-do-icon span' => 'background: {{VALUE}} !important',

			),
		)
	);
	
	
	$this->add_control(
		'icon_hover_bgcolor',
		array(
			'label'     => __( 'Background Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_icon' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-link-2 a:hover' => 'background: {{VALUE}} !important',
				'{{WRAPPER}} .what-we-do-icon span:hover' => 'background: {{VALUE}} !important',

			),
		)
	);	


	$this->end_controls_section();		
	
	//End of icon



	//========== Button with Background ===================================

	$this->start_controls_section(
		'button_control',
		array(
			'label' => __( 'Button Settings', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'show_button',
		array(
			'label' => esc_html__( 'Show Button', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .service-area .fill-btn' => 'display: {{VALUE}} !important',
			),
		)
	);		
	$this->add_control(
		'button_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'condition'    => array( 'show_button' => 'show' ),
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'left',
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}} .service-area .fill-btn' => 'text-align: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_color',
		array(
			'label'     => __( 'Button Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-area .fill-btn' => 'color: {{VALUE}} !important',

			),
		)
	);
	$this->add_control(
		'button_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-area .fill-btn' => 'background: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-area .fill-btn:before' => 'background: {{VALUE}} !important',
			),
		)
	);				
	$this->add_control(
		'button_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .service-area .fill-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'button_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
			'selectors' => array(
				'{{WRAPPER}} .service-area .fill-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'button_typography',
			'condition'    => array( 'show_button' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .service-area .fill-btn',
		)
	);
	$this->add_group_control(
		\Elementor\Group_Control_Border::get_type(),
		array(
			'name' => 'border',
			'condition'    => array( 'show_button' => 'show' ),
			'selector' => '{{WRAPPER}} .service-area .fill-btn',
		)
	);
	$this->add_control(
		'border_radius',
		array(
			'label' => esc_html__( 'Border Radius', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' => [ 'px', '%' ],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 1000,
					'step' => 5,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 50,
			],
			'selectors' => [
				'{{WRAPPER}} .service-area .fill-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		)
	);

	$this->end_controls_section();

	//End of Button	


	//Background Color ==========================

	$this->start_controls_section(
		'bg_color_block_settings',
		array(
			'label' => __( 'Background Color Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);			

	$this->add_control(
		'block_bg_color',
		array(
			'label'     => __( 'Section Background Color', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .service-area' => 'background-color: {{VALUE}} !important',
			),
		)
	);	


	$this->end_controls_section();

	//End of Background Color  


	//Section Padding Block==========================
	$this->start_controls_section(
		'section_padding_settings',
		array(
			'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'block_margin',
		array(
			'label'     => __( 'Block Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .service-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				'{{WRAPPER}} .what-we-do-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->add_control(
		'block_padding',
		array(
			'label'     => __( 'Block Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .service-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				'{{WRAPPER}} .what-we-do-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->end_controls_section();
	//End of Section Padding Block 



	}

	public function render() {

		$settings  = $this->get_settings_for_display(); 
		extract( $settings );

		$cat = get_term_by('name', $cat, 'service_categories');
		if( !empty($cat->term_id) ){
			$term_id = $cat->term_id;
		}
 
		if( $chose_style == 'service-style-1' ): 
			$extraClass = ( $settings['show_heading_section'] == 'yes') ? '' : 'empty-area-title';
		?>




		<?php
			echo '
			<script>
		jQuery(document).ready(function($) {

		//write js code under this line 

		var service = new Swiper(".service-active-2", {
			slidesPerView: 3,
			spaceBetween: 30,
			loop: true,
			autoplay: {
				delay: 3000,
			},
			pagination: {
				el: ".bd-swiper-dot",
				clickable: true,
			},
			breakpoints: {
				"1200": {
					slidesPerView: 3,
				},
				"992": {
					slidesPerView: 3,
				},
				"768": {
					slidesPerView: 2,
				},
				"576": {
					slidesPerView: 1,
				},
				"0": {
					slidesPerView: 1,
				},
			},
		});

		//write code above the line 

		});
		</script>';


		?>

	

   <!-- Service area start -->
   <section class="service-area theme-bg-2 section-space <?php echo esc_attr( $extraClass ); ?>">
      <div class="container">
         <div class="row section-title-spacing justify-content-center">

            <div class="col-xxl-5 col-xl-5 col-lg-6">
				<?php 
				if( $settings['show_heading_section'] == 'yes'): ?>
               <div class="section-title-wrapper text-center">
			   		<?php 
					if (( '' !== $sub_heading ) && ( $show_sub_heading )) : ?>
                  <div class="section-subtitle">
                     <span><?php echo wp_kses_post( $sub_heading ); ?></span>
                  </div>
				  <?php 
					endif; ?>
					<?php 
					if (( '' !== $heading ) && ( $show_heading )) : ?>
                  <h2 class="section-title"><?php echo wp_kses_post( $heading ); ?></h2>
				  <?php 
					endif; ?>
               </div>
			   <?php
				endif; ?>
            </div>
         </div>
         <div class="row gy-5">
			<?php 
			if( !empty($cat->term_id) ){
				$q = new \WP_Query(array(
					'post_type'     => 'dogri-service',
					'posts_per_page'=> $post_number,
					'orderby' 		=> 'menu_order '.$orderby,
					'order'			=> $post_order,
					'tax_query' => array(
						array(
							'taxonomy' => 'service_categories',
							'field'    => 'term_id',
							'terms'    => array( $term_id ),
							'operator' => 'IN',
						),
					),
				));
			
			}else{
				$q = new \WP_Query(array(
					'post_type'     => 'dogri-service',
					'posts_per_page'=> $post_number,
					'orderby' 		=> 'menu_order '.$orderby,
					'order'			=> $post_order,
				));
			}
				
			if($q->have_posts()):
				while($q->have_posts()): $q->the_post(); 
					$icon_thumb = get_post_meta(get_the_ID(), 'service_icon_thumb', true);
					$tiny_content = get_post_meta(get_the_ID(), 'service_tiny_text', true);
				?>
            <div class="col-xxl-4 col-xl-4 col-lg-4 col-md-6">
               <div class="service-item wow fadeInUp" data-wow-delay=".3s">
                  <div class="service-thumb w-img">

                     <a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url('dogri-service-thumb'); ?>" alt=""></a>
					
                  </div>
                  <div class="service-content">
                     <h4><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h4>
                     <p><?php echo wp_trim_words( $tiny_content, $content_word_count, '' ); ?></p>
                     <div class="service-link"><a href="<?php the_permalink(); ?>"><i
                              class="fa-regular fa-angle-right"></i></a>
                     </div>
                     <div class="service-icon">
					 <?php 
					if( $icon_thumb ): ?>
                        <span><img src="<?php echo esc_url($icon_thumb); ?>" alt="<?php echo esc_attr__('icon', 'dogri-elementor'); ?>"></span>
						<?php 
					endif; ?>
                     </div>
                  </div>
               </div>
            </div>
			<?php 
				endwhile; 
				wp_reset_postdata(); 
			endif; 
			?>
         </div>
         <div class="btn-wrapper text-center">
            <a href="<?php echo esc_url($settings['btnlink']['url']);?>" class="fill-btn">
               <span class="fill-btn-inner">
                  <span class="fill-btn-normal"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
                  <span class="fill-btn-hover"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
               </span>
            </a>
         </div>		 
      </div>
   </section>
   <!-- Service area end -->

	<?php 
	elseif( $chose_style == 'service-style-2' ): ?>

	<!-- Service area start -->
	<section class="service-area theme-bg-4 section-space p-relative">
		<div class="container">
			<div class="row justify-content-center section-title-space">
				<div class="col-xxl-5 col-xl-5">
					<?php 
					if( $settings['show_heading_section'] == 'yes'): ?>
				<div class="section-title-wrapper-4 text-center">
						<?php 
						if (( '' !== $sub_heading ) && ( $show_sub_heading )) : ?>
					<div class="section-subtitle-5 mb-25">
						<span><?php echo wp_kses_post( $sub_heading ); ?></span>
					</div>
					<?php 
						endif; ?>
						<?php 
						if (( '' !== $heading ) && ( $show_heading )) : ?>
					<h2 class="section-title-3"><?php echo wp_kses_post( $heading ); ?></h2>
					<?php 
						endif; ?>
				</div>
				<?php
					endif; ?>
				</div>
			</div>
			<div class="row wow fadeIn" data-wow-delay=".3s">
			
				<div class="col-xxl-12">
					<div class="swiper service-active-2">
						<div class="swiper-wrapper">
						<?php 
						if( !empty($cat->term_id) ){
							$q = new \WP_Query(array(
								'post_type'     => 'dogri-service',
								'posts_per_page'=> $post_number,
								'orderby' 		=> 'menu_order '.$orderby,
								'order'			=> $post_order,
								'tax_query' => array(
									array(
										'taxonomy' => 'service_categories',
										'field'    => 'term_id',
										'terms'    => array( $term_id ),
										'operator' => 'IN',
									),
								),
							));
						
						}else{
							$q = new \WP_Query(array(
								'post_type'     => 'dogri-service',
								'posts_per_page'=> $post_number,
								'orderby' 		=> 'menu_order '.$orderby,
								'order'			=> $post_order,
							));

						}
							
						if($q->have_posts()):
							while($q->have_posts()): $q->the_post(); 
								$icon_thumb = get_post_meta(get_the_ID(), 'service_icon_thumb', true);
								$tiny_content = get_post_meta(get_the_ID(), 'service_tiny_text', true);
							?>
							<div class="swiper-slide">
								<div class="service-item-4">
									<div class="service-thumb-4">
										<a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url('dogri-service-thumb'); ?>" alt=""></a>
										<div class="service-link-2"><a href="<?php the_permalink(); ?>"><i
												class="fa-regular fa-angle-right"></i></a></div>
									</div>
									<div class="service-content-4">
									<h4><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h4>
									<p><?php echo wp_trim_words( $tiny_content, $content_word_count, '' ); ?></p>
									</div>
								</div>
							</div>
							<?php 
							endwhile; 
							wp_reset_postdata(); 
							endif; 
							?>
						</div>
						<div class=" why-choose-pagination text-center">
						<div class="bd-swiper-dot"></div>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</section>
		<!-- Service area end -->

	<?php 
	elseif( $chose_style == 'service-style-3' ): ?>

	<!-- What we do area start -->
	<section class="what-we-do-area section-space p-relative">
		<div class="container">
		<div class="row g-5 align-items-end justify-content-between section-title-space">
			<div class="col-xxl-6 co-xl-6 col-lg-6">
				<?php 
					if( $settings['show_heading_section'] == 'yes'): ?>
				<div class="section-title-wrapper-5">
						<?php 
						if (( '' !== $sub_heading ) && ( $show_sub_heading )) : ?>
					<div class="section-subtitle-6 mb-20">
						<span><?php echo wp_kses_post( $sub_heading ); ?></span>
					</div>
					<?php 
						endif; ?>
						<?php 
						if (( '' !== $heading ) && ( $show_heading )) : ?>
					<h2 class="section-title-3"><?php echo wp_kses_post( $heading ); ?></h2>
					<?php 
						endif; ?>
				</div>
				<?php
					endif; ?>
			</div>
			<div class="col-xxl-5 co-xl-5 col-lg-6">
			<?php if($settings['bttn']): ?>
				<div class="section-short-intro">
					<p><?php echo $settings['text'];?></p>
					<a class="text-btn" href="<?php echo esc_url($settings['btnlink']['url']);?>"><?php echo $settings['bttn'];?><span><i class="fa-regular fa-angle-right"></i></span></a>
				</div>
				<?php endif; ?>
			</div>
		</div>
		<div class="row gy-50 align-items-center">
		<?php 
		if( !empty($cat->term_id) ){
			$q = new \WP_Query(array(
				'post_type'     => 'dogri-service',
				'posts_per_page'=> $post_number,
				'orderby' 		=> 'menu_order '.$orderby,
				'order'			=> $post_order,
				'tax_query' => array(
					array(
						'taxonomy' => 'service_categories',
						'field'    => 'term_id',
						'terms'    => array( $term_id ),
						'operator' => 'IN',
					),
				),
			));
		
		}else{
			$q = new \WP_Query(array(
				'post_type'     => 'dogri-service',
				'posts_per_page'=> $post_number,
				'orderby' 		=> 'menu_order '.$orderby,
				'order'			=> $post_order,
			));

		}
			
		if($q->have_posts()):
			while($q->have_posts()): $q->the_post(); 
				$icon_thumb = get_post_meta(get_the_ID(), 'service_icon_thumb', true);
				$tiny_content = get_post_meta(get_the_ID(), 'service_tiny_text', true);
			?>
			<div class="col-xl-4 co-xl-4 col-lg-4">
				<div class="what-we-do-item wow fadeIn" data-wow-delay=".3s">
					<div class="what-we-do-icon">
					<span>
						<?php 
						if( $icon_thumb ): ?>
							<img src="<?php echo esc_url($icon_thumb); ?>" alt="<?php echo esc_attr__('icon', 'dogri-elementor'); ?>">
							<?php 
						endif; ?>
					</span>
					</div>
					<div class="what-we-do-content">
					<h4><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), $heading_word_count, '' ); ?></a></h4>
					<p><?php echo wp_trim_words( $tiny_content, $content_word_count, '' ); ?></p>
					</div>
					<a class="round-link-40" href="<?php the_permalink(); ?>"><i class="fa-regular fa-angle-right"></i></a>
				</div>
			</div>
			<?php 
			endwhile; 
			wp_reset_postdata(); 
			endif; 
			?>
		</div>
		</div>
	</section>
	<!-- What we do area end -->


	<?php 
	endif; ?>	



	<?php
	}
}