<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Doctor_Team_Widget extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'doctor_team_widget';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Doctors Team Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'doctor_team_widget',
			[
				'label' => esc_html__( 'Doctors Team Widget', 'dogri-elementor' ),
			]
		);		


		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'dogri-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'dogri-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'dogri-elementor' ),
					'style3'   => esc_html__( 'Style Three', 'dogri-elementor' ),
				),
			]
		);


		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								
								'block_image' =>
								[
									'name' => 'block_image',
									'label' => __( 'Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								  ],	

								  'block_alt_text' =>
								  [
								  'name' => 'block_alt_text',
								  'label' => esc_html__('Image Alt Text', 'dogri-elementor'),
								  'type' => Controls_Manager::TEXTAREA,
								  'default' => esc_html__('', 'dogri-elementor')
								  ],

								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_btnlink' =>
								[
									'name' => 'block_btnlink',
									'label' => __( 'Title Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_subtitle' =>
								 [
									 'name' => 'block_subtitle',
									 'label' => esc_html__('Sub Title', 'dogri-elementor'),
									 'type' => Controls_Manager::TEXTAREA,
									 'default' => esc_html__('', 'dogri-elementor')
								 ],

								 'block_icons' =>
								 [
									'name' => 'block_icons',
									'label' => esc_html__('Enter The icons', 'dogri-elementor'),
									'type' => Controls_Manager::ICONS,							
								],

								 'block_btnlink1' =>
								[
									'name' => 'block_btnlink1',
									'label' => __( 'Fb Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_icons1' =>

								 [
									'name' => 'block_icons1',
									'label' => esc_html__('Enter The icons', 'dogri-elementor'),
									'type' => Controls_Manager::ICONS,							
								],

								 'block_btnlink2' =>
								[
									'name' => 'block_btnlink2',
									'label' => __( 'Twitter Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_icons2' =>
								 [
									'name' => 'block_icons2',
									'label' => esc_html__('Enter The icons', 'dogri-elementor'),
									'type' => Controls_Manager::ICONS,							
								],

								 'block_btnlink3' =>
								[
									'name' => 'block_btnlink3',
									'label' => __( 'Twitter Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],
																
								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 


//write code above the line 

  });
</script>';


?>

<?php  if ( 'style1' === $settings['style'] ) : ?>
<!-- Doctor area start -->
<section class="doctor-area section-space">
	<div class="container">
		<div class="row g-3">
			<?php foreach($settings['repeat'] as $item):?>
			<div class="col-xxl-4 col-xl-4 col-lg-4">
				<div class="doctor-item-3 p-relative">
					<div class="doctor-thumb-3 fix w-img mb-25">
					<a href="<?php echo esc_url($item['block_btnlink']['url']);?>">
						<img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
					</a>
					</div>
					<div class="doctor-content">
					<h4 class="doctor-title"><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
					<span><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
					</div>
					<div class="doctor-social-3">
					<ul>
						<li><a href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons']['value']));?>"></i></a></li>
						<li><a href="<?php echo esc_url($item['block_btnlink2']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons1']['value']));?>"></i></a></li>
						<li><a href="<?php echo esc_url($item['block_btnlink3']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons2']['value']));?>"></i></a></li>
					</ul>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
	</div>
</section>
<!-- Doctor area end -->

<?php  elseif ( 'style2' === $settings['style'] ) : ?>

<!-- Doctor area start -->
<section class="doctor-area section-space">
	<div class="container">
		<div class="row gy-50">
			<?php foreach($settings['repeat'] as $item):?>
			<div class="col-xxl-4 col-xl-4 col-lg-4">
				<div class="doctor-item-2 text-center p-relative">
					<div class="doctor-thumb-2 w-img">
					<a href="<?php echo esc_url($item['block_btnlink']['url']);?>">
						<img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
					</a>
					</div>
					<div class="doctor-card">
					<h4 class="doctor-title"><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
					<span><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
					</div>
					<div class="doctor-card-2">
					<h4 class="doctor-title"><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
					<span><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
					<div class="doctor-social">
						<a href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons']['value']));?>"></i></a>
						<a href="<?php echo esc_url($item['block_btnlink2']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons1']['value']));?>"></i></a>
						<a href="<?php echo esc_url($item['block_btnlink3']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons2']['value']));?>"></i></a>
					</div>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
	</div>
</section>

<!-- Doctor area end -->

<?php  elseif ( 'style3' === $settings['style'] ) : ?>

<!-- Doctor area start -->
<section class="doctor-area section-space">
	<div class="container">
		<div class="row gy-50">
			<?php foreach($settings['repeat'] as $item):?>
			<div class="col-xxl-4 col-xl-4 col-lg-4">
				<div class="team-item text-center">
					<div class="team-thumb fix">
					<a href="<?php echo esc_url($item['block_btnlink']['url']);?>">
						<img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
					</a>
					</div>
					<div class="team-content">
					<h4 class="team-title"><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
					<span><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
					<div class="team-social">
						<a href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons']['value']));?>"></i></a>
						<a href="<?php echo esc_url($item['block_btnlink2']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons1']['value']));?>"></i></a>
						<a href="<?php echo esc_url($item['block_btnlink3']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons2']['value']));?>"></i></a>
					</div>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
	</div>
</section>
<!-- Doctor area end -->

<?php endif ;?>	


             
		<?php 
	}


}