<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Blog_Post_Widget extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Dogri Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'blog_post_widget';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Dogri Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Blog Post Widget', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Dogri Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-content';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Dogri Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}

	public function get_keywords() {
		return [ 'blog-post' ];
	}

	public function get_script_depends() {
		return [ 'dogri-elementor'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Blog_Post_Widget',
			[
				'label' => esc_html__( 'Section Heading', 'dogri-elementor' ),
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label'       => __( 'Sub Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => __( 'It is sub heading', 'dogri-elementor' ),
				'placeholder' => __( 'Enter your subheading here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __( 'Heading', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => __( 'It is heading', 'dogri-elementor' ),
				'placeholder' => __( 'Enter your heading here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);
		

		$this->end_controls_section();


		$this->start_controls_section(
			'section_content_service_post',
			[
				'label' => esc_html__( 'Blog Post', 'dogri-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Chose Style', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'blog-style-1'  => esc_html__( 'Latest Blog Style 1', 'dogri-elementor' ),
					'blog-style-2' => esc_html__( 'Latest Blog Style 2', 'dogri-elementor' ),
					'blog-style-3' => esc_html__( 'Latest Blog Style 3', 'dogri-elementor' ),
					'blog-style-4' => esc_html__( 'Latest Blog Style 4', 'dogri-elementor' ),
					'blog-style-5' => esc_html__( 'Latest Blog Style 5', 'dogri-elementor' ),
				],
				'default'   => 'blog-style-1',
			]
		);

		$this->add_control(
			'heading_word_count',
			[
				'label'       => __( 'Heading Word Count', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Type Heading Words Number', 'dogri-elementor' ),
				'default'   => 7,				
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'ID'  => esc_html__( 'Post ID', 'dogri-elementor' ),
					'title'  => esc_html__( 'Title', 'dogri-elementor' ),
					'date' => esc_html__( 'Date', 'dogri-elementor' ),
					'modified' => esc_html__( 'Last Modified Date', 'dogri-elementor' ),
					'rand' => esc_html__( 'Random Order', 'dogri-elementor' ),
					'comment_count' => esc_html__( 'Popular Post', 'dogri-elementor' ),
				],
				'default'   => 'ID',
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Post Order', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'dogri-elementor' ),
					'desc' => esc_html__( 'DESC', 'dogri-elementor' ),
				],
				'default'   => 'desc',
			]
		);		

		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Post Count', 'dogri-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'1'  => esc_html__( '1', 'dogri-elementor' ),
					'2'  => esc_html__( '2', 'dogri-elementor' ),
					'3'  => esc_html__( '3', 'dogri-elementor' ),
					'4'  => esc_html__( '4', 'dogri-elementor' ),
					'5'  => esc_html__( '5', 'dogri-elementor' ),
					'6' => esc_html__( '6', 'dogri-elementor' ),
					'7' => esc_html__( '7', 'dogri-elementor' ),
					'8' => esc_html__( '8', 'dogri-elementor' ),
					'9' => esc_html__( '9', 'dogri-elementor' ),
					'10' => esc_html__( '10', 'dogri-elementor' ),
					'-1' => esc_html__( 'Show All', 'dogri-elementor' ),
				],
				'default'   => '3',
			]
		);

		$this->add_control(
			'cat',
			[
				'label'       => __( 'Category Slug', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter category slug here...', 'dogri-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'dogri-elementor' ),
			]
		);		

		$this->add_control(
			'show_heading_section',
			[
				'label'   => esc_html__( 'Show Heading Section', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => esc_html__( 'Show title', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);	

		$this->add_control(
			'show_sub_title',
			[
				'label'   => esc_html__( 'Show Sub Title', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'condition' => [
					'show_heading_section' => 'yes'
				],
			]
		);


		$this->add_control(
			'show_link',
			[
				'label'   => esc_html__( 'Show Link', 'dogri-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();


    //Background Color ==========================

    $this->start_controls_section(
        'bg_color_block_settings',
        array(
            'label' => __( 'Background Color Setting', 'dogri-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        )
    );			

    $this->add_control(
        'block_bg_color',
        array(
            'label'     => __( 'Section Background Color', 'dogri-elementor' ),
            'type'      => \Elementor\Controls_Manager::COLOR,
            'selectors' => array(
                '{{WRAPPER}} .blog__area' => 'background: {{VALUE}} !important',
                '{{WRAPPER}} .blog-area' => 'background: {{VALUE}} !important',
            ),
        )
    );  

    $this->end_controls_section();      

    //End of Background Color  

	//Section Sub Title	==================		

	$this->start_controls_section(
		'section_subtitle_settings',
		array(
			'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'show_section_subtitle',
		array(
			'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .blog__area .section-subtitle span' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-3' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-5' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-6' => 'display: {{VALUE}} !important',
			), 
		)
	);
	
	$this->add_control(
		'section_subtitle_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_section_subtitle' => 'show' ),
			'toggle' => true,
			'selectors' => array(
			
				'{{WRAPPER}} .blog__area .section-subtitle' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-3' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-5' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-6' => 'text-align: {{VALUE}} !important',
			),
		)
	);
	
	$this->add_control(
		'section_subtitle_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'condition'    => array( 'show_section_subtitle' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
		'{{WRAPPER}} .blog__area .section-subtitle span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .section-subtitle-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .section-subtitle-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .section-subtitle-6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			),
		)
	);
	
	$this->add_control(
		'section_subtitle_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'condition'    => array( 'show_section_subtitle' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
		'{{WRAPPER}} .blog__area .section-subtitle span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .section-subtitle-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .section-subtitle-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
		'{{WRAPPER}} .section-subtitle-6' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			),
		)
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
	
		array(
			'name'     => 'section_subtitle_typography',
			'condition'    => array( 'show_section_subtitle' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .blog__area .section-subtitle span',
			'selector' => '{{WRAPPER}} .section-subtitle-3',
			'selector' => '{{WRAPPER}} .section-subtitle-5',
			'selector' => '{{WRAPPER}} .section-subtitle-6',
		)
	);
	
	
	$this->add_control(
		'section_subtitle_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_section_subtitle' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .blog__area .section-subtitle span' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-3' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-5' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-6' => 'color: {{VALUE}} !important',
			),
		
		)
	);

	$this->add_control(
		'section_subtitle_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_section_subtitle' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .blog__area .section-subtitle span' => 'background-color: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-3' => 'background-color: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-5' => 'background-color: {{VALUE}} !important',
				'{{WRAPPER}} .section-subtitle-6' => 'background-color: {{VALUE}} !important',
			),
		
		)
	);

	$this->end_controls_section();		
	//End of  Sub Title 	==================	 



	// Section Title 	==================
		
	$this->start_controls_section(
		'section_title_settings',
		array(
			'label' => __( 'Section Title Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);		
	
	$this->add_control(
		'show_section_title',
		array(
			'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .blog__area .section-title' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .section-title-3' => 'display: {{VALUE}} !important',
			),
		)
	);
	
	$this->add_control(
		'section_title_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_section_title' => 'show' ),
			'toggle' => true,
			'selectors' => array(
			
				'{{WRAPPER}} .blog__area .section-title' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .section-title-3' => 'text-align: {{VALUE}} !important',
			),
		)
	);
	
	$this->add_control(
		'section_title_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'condition'    => array( 'show_section_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .blog__area .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .section-title-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'section_title_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'condition'    => array( 'show_section_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .blog__area .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .section-title-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'section_title_typography',
			'condition'    => array( 'show_section_title' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .blog__area .section-title',
			'selector' => '{{WRAPPER}} .section-title-3',
		)
	);
	
	$this->add_control(
		'section_title_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_section_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .blog__area .section-title' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .section-title-3' => 'color: {{VALUE}} !important',
			),
		)
	);

	$this->end_controls_section();					
	//End of  Title 	==================	
	
	//Section Padding Block==========================
	$this->start_controls_section(
		'section_padding_settings',
		array(
			'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'block_margin',
		array(
			'label'     => __( 'Block Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .blog__area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				'{{WRAPPER}} .blog-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->add_control(
		'block_padding',
		array(
			'label'     => __( 'Block Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .blog__area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				'{{WRAPPER}} .blog-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->end_controls_section();
	//End of Section Padding Block 





	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings);	

	    $cat = get_term_by('slug', $cat, 'category');
	    if( !empty($cat->term_id) ){
	        $term_id = $cat->term_id;
	    }else{
	        $term_id = 1;
	    }

		if( $chose_style == 'blog-style-1' ): ?>

  <!-- BLog area start -->
  <section class="blog__area theme-bg-2 section-space">
      <div class="container">
         <div class="row justify-content-center">
            <div class="col-xxl-12">
				<?php 
				if( $settings['show_heading_section'] == 'yes'): ?>
               <div class="section-title-wrapper text-center section-title-spacing">

			   <?php 
				if (( '' !== $sub_title ) && ( $show_sub_title )) : ?>
					<div class="section-subtitle"><span><?php print wp_kses_post( $sub_title ); ?></span></div>
				<?php 
				endif; ?> 
                <?php 
				if (( '' !== $title ) && ( $show_title )) : ?>
						<h2 class="section-title"><?php print wp_kses_post( $title ); ?></h2>
				<?php 
				endif; ?>
               </div>
			   <?php
				endif; ?>  
            </div>
         </div>
         <div class="row g-5 section-title-spacing">
			<?php 
				$q = new \WP_Query(array(
					'post_type'     => 'post',
					'posts_per_page'=> $number,
					'cat'			=> $term_id,
					'orderby'       => 'menu_order '.$orderby,
					'order'         => $order,
					'tax_query' => array(
						array(
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms' => array( 
								'post-format-image', 
							),
							'operator' => 'IN',
						),
					),
				));

			if($q->have_posts()):
				while($q->have_posts()): $q->the_post(); 
				$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
				?>
            <div class="col-xl-6 col-xl-6 col-lg-6">
               <div class="blog-item white-bg">
                  <div class="blog-thumb mb-20 w-img">
				  	<?php
					if( $featured_post_img !== "" ): ?>
						<figure class="image">
							<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1" /></a>
						</figure>
					<?php
					else: ?>
						<figure class="image">
						<a href="<?php the_permalink(); ?>"><img src="<?php the_post_thumbnail_url('dogri-featured-post-full'); ?>" alt="post-1" /></a>
						</figure>
					<?php
					endif; ?>
                     <div class="blog-badge">
                        <span><?php dogri_get_category_without_icon(); ?></span>
                     </div>
                  </div>
                  <div class="blog-content">
                     <div class="postbox__meta mb-15">
                        <span><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php print get_the_author(); ?></a></span>
                        <span><?php the_time(get_option('date_format')); ?></span>
                     </div>
                     <h4 class="blog-title">
                        <a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a>
                     </h4>
                     <a class="round-link" href="<?php the_permalink(); ?>"><i class="fa-regular fa-angle-right"></i></a>
                  </div>
               </div>
            </div>
			<?php 
				endwhile; 
				wp_reset_postdata(); 
			endif; 
			?> 
         </div>
      </div>
   </section>
   <!-- BLog area end -->

	<?php 
	elseif ($chose_style == 'blog-style-2') : ?>
	
	   <!-- Blog area sart -->
	   <section class="blog-area section-space">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-4 col-xl-4 col-lg-4">	
			   <?php 
				if( $settings['show_heading_section'] == 'yes'): ?>			 
			   <div class="section-title-wrapper-3 text-center mb-35">
			   <?php 
				if (( '' !== $sub_title ) && ( $show_sub_title )) : ?>
                     <span class="section-subtitle-3 mb-15"><?php print wp_kses_post( $sub_title ); ?></span>
				<?php
				endif; ?>  
     			<?php 
				if (( '' !== $title ) && ( $show_title )) : ?>
                     <h2 class="section-title-3"><?php print wp_kses_post( $title ); ?></h2>
				<?php
				endif; ?>  
                  </div>
               </div>
			   <?php
				endif; ?>  
            </div>
            <div class="row g-5 section-title-space">
			<?php 
				$q = new \WP_Query(array(
					'post_type'     => 'post',
					'posts_per_page'=> $number,
					'cat'			=> $term_id,
					'orderby'       => 'menu_order '.$orderby,
					'order'         => $order,
					'tax_query' => array(
						array(
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms' => array( 
								'post-format-image', 
							),
							'operator' => 'IN',
						),
					),
				));

			if($q->have_posts()):
				while($q->have_posts()): $q->the_post(); 
				$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
				?>
               <div class="col-xxl-4 col-xl-4 col-lg-4">
                  <div class="blog-item-3">
                     <div class="blog-thumb-bg include-bg" data-background="<?php echo esc_url($featured_post_img); ?>"></div>
                     <div class="blog-tag-wrapper">
					 	<?php dogri_get_category_without_icon(); ?>
                     </div>
                     <span class="divider"></span>
                     <div class="postbox__meta mb-15">
						<span><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">By <?php print get_the_author(); ?></a></span>
                        <span><?php the_time(get_option('date_format')); ?></span>
                     </div>
                     <div class="blog-content-3">
                        <h4><a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a></h4>
                     </div>
                     <a class="round-link" href="<?php the_permalink(); ?>"><i class="fa-regular fa-angle-right"></i></a>
                  </div>
               </div>
			   <?php 
				endwhile; 
				wp_reset_postdata(); 
			endif; 
			?> 
            </div>
         </div>
      </section>
      <!-- Blog area end -->

	<?php 
	elseif ($chose_style == 'blog-style-3') : ?>
  <!-- Postbox grid area start -->
  <section class="postbox__grid-area section-space">
         <div class="container">
            <div class="row g-5">
			<?php 
				$q = new \WP_Query(array(
					'post_type'     => 'post',
					'posts_per_page'=> $number,
					'cat'			=> $term_id,
					'orderby'       => 'menu_order '.$orderby,
					'order'         => $order,
					'tax_query' => array(
						array(
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms' => array( 
								'post-format-image', 
							),
							'operator' => 'IN',
						),
					),
				));

			if($q->have_posts()):
				while($q->have_posts()): $q->the_post(); 
				$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
				?>
               <div class="col-xl-6 col-xl-6 col-lg-6">
                  <div class="blog-item theme-bg-2">
                     <div class="blog-thumb mb-20 w-img">
					 	<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1" /></a>
                        <div class="blog-badge">
                           <span><?php dogri_get_category_without_icon(); ?></span>
                        </div>
                     </div>
                     <div class="blog-content">
                        <div class="postbox__meta mb-15">
						<span><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">By <?php print get_the_author(); ?></a></span>
                        <span><?php the_time(get_option('date_format')); ?></span>
                        </div>
						<h4 class="blog-title"><a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a></h4>
						<a class="round-link" href="<?php the_permalink(); ?>"><i class="fa-regular fa-angle-right"></i></a>
                     </div>
                  </div>
               </div>
			   <?php 
				endwhile; 
				wp_reset_postdata(); 
			endif; 
			?> 
            </div>
         </div>
      </section>
      <!-- Postbox grid area end -->
	  <?php 
	elseif ($chose_style == 'blog-style-4') : ?>
	
		      <!-- Blog area sart -->
		<section class="blog-area section-space">
         <div class="container">
            <div class="row justify-content-center section-title-space">
               <div class="col-xl-6 co-xl-6 col-lg-6">

				<?php 
				if( $settings['show_heading_section'] == 'yes'): ?>			 
			   <div class="section-title-wrapper-4 text-center">
			   <?php 
				if (( '' !== $sub_title ) && ( $show_sub_title )) : ?>
                     <span class="section-subtitle-5 mb-25"><?php print wp_kses_post( $sub_title ); ?></span>
				<?php
				endif; ?>  
     			<?php 
				if (( '' !== $title ) && ( $show_title )) : ?>
                     <h2 class="section-title-3"><?php print wp_kses_post( $title ); ?></h2>
				<?php
				endif; ?>  
                  </div>
               </div>
			   <?php
				endif; ?>  

               </div>
            </div>
            <div class="row gy-5 wow fadeIn" data-wow-delay=".3s">
			<?php 
				$q = new \WP_Query(array(
					'post_type'     => 'post',
					'posts_per_page'=> $number,
					'cat'			=> $term_id,
					'orderby'       => 'menu_order '.$orderby,
					'order'         => $order,
					'tax_query' => array(
						array(
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms' => array( 
								'post-format-image', 
							),
							'operator' => 'IN',
						),
					),
				));

			if($q->have_posts()):
				while($q->have_posts()): $q->the_post(); 
				$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
				?>
               <div class="col-xxl-4 col-xl-4 col-lg-4">
                  <div class="blog-item-5">
                     <div class="blog-item-thumb-5 w-img">
					 	<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1" /></a>
                     </div>
                     <div class="blog-content-5">
                        <div class="postbox__meta mb-10">
						<span><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">By <?php print get_the_author(); ?></a></span>
                        <span><?php the_time(get_option('date_format')); ?></span>
                        </div>
                        <h4 class="blog-title-5">
							<a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a>
                        </h4>
                     </div>
                  </div>
               </div>
			   <?php 
				endwhile; 
				wp_reset_postdata(); 
			endif; 
			?> 
            </div>
         </div>
      </section>
      <!-- Blog area end -->

	  <?php 
	elseif ($chose_style == 'blog-style-5') : ?>

	<!-- BLog area start -->
	<section class="blog__area section-space">
         <div class="container">
            <div class="row g-5 align-items-end justify-content-between section-title-space">
               <div class="col-xxl-5 col-xl-5 col-lg-6">
				  <?php 
					if( $settings['show_heading_section'] == 'yes'): ?>			 
					<div class="section-title-wrapper-5">
						<?php 
						if (( '' !== $sub_title ) && ( $show_sub_title )) : ?>
							<span class="section-subtitle-6 mb-25"><?php print wp_kses_post( $sub_title ); ?></span>
						<?php
						endif; ?>  
						<?php 
						if (( '' !== $title ) && ( $show_title )) : ?>
							<h2 class="section-title-3"><?php print wp_kses_post( $title ); ?></h2>
						<?php
						endif; ?>  
					</div>
					<?php
					endif; ?>  
            	</div>
			</div>
            <div class="row wow fadeInUp" data-wow-delay=".5s">
				<?php 
				$q = new \WP_Query(array(
					'post_type'     => 'post',
					'posts_per_page'=> $number,
					'cat'			=> $term_id,
					'orderby'       => 'menu_order '.$orderby,
					'order'         => $order,
					'tax_query' => array(
						array(
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms' => array( 
								'post-format-image', 
							),
							'operator' => 'IN',
						),
					),
				));

				if($q->have_posts()):
					while($q->have_posts()): $q->the_post(); 
					$featured_post_img = get_post_meta( get_the_ID(), 'featured_blog_image', true );
					?>
               <div class="col-xl-6 col-xl-6 col-lg-6">
                  <div class="blog-item theme-bg-2">
                     <div class="blog-thumb mb-20 w-img">
					 	<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($featured_post_img); ?>" alt="post-1" /></a>
                        <div class="blog-badge">
                           <span><?php dogri_get_category_without_icon(); ?></span>
                        </div>
                     </div>
                     <div class="blog-content">
                        <div class="postbox__meta mb-15">
						<span><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">By <?php print get_the_author(); ?></a></span>
                        <span><?php the_time(get_option('date_format')); ?></span>
                        </div>
                        <h4 class="blog-title">
							<a href="<?php the_permalink(); ?>"><?php print wp_trim_words(get_the_title(), $heading_word_count, ''); ?></a>
                        </h4>
                        <a class="round-link" href="<?php the_permalink(); ?>"><i class="fa-regular fa-angle-right"></i></a>
                     </div>
                  </div>
               </div>
			   <?php 
					endwhile; 
					wp_reset_postdata(); 
				endif; 
				?> 
            </div>
         </div>
    </section>
      <!-- BLog area end -->

	<?php 
	endif; ?>

	<?php
	}
}