<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package dogri
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function dogri_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}
	return $classes;
}
add_filter( 'body_class', 'dogri_body_classes' );

/**
 * Get tags.
 */
function dogri_get_tag() {
	$html = '';
	if(has_tag()) {
		$html .= '<div class="blog-post-tag"><h5>'. esc_html__('Tags:','dogri') .'</h5><div class="post-tag-list">';
			$html .= get_the_tag_list('',' ','');
		$html .= '</div></div>';
	}
	return $html;
}


/**
 * Get categories.
 */
function dogri_get_category() {

$categories = get_the_category( get_the_ID() );
	$x = 0;
	foreach ($categories as $category){
		
	if($x==1){
		break;
	}	
	$x++;
	print '<span><a class="news-tag" href="' . get_category_link($category->term_id) . '"><i class="fa-light fa-folder-open"></i> '  . $category->cat_name . '</a></span>';

	}
}

/**
 * Get categories without icon
 */
function dogri_get_category_without_icon() {

$categories = get_the_category( get_the_ID() );
	$x = 0;
	foreach ($categories as $category){
		
	if($x==1){
		break;
	}	
	$x++;
	print '<span><a class="news-tag" href="' . get_category_link($category->term_id) . '">'  . $category->cat_name . '</a></span>';

	}
}


/** img alt-text **/
function dogri_img_alt_text( $img_er_id = null ){
	$image_id = $img_er_id;
	$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', false);
	$image_title = get_the_title($image_id);

	if( !empty($image_id) ){
		if($image_alt){
			$alt_text = get_post_meta($image_id, '_wp_attachment_image_alt', false);
		}else{
			$alt_text = get_the_title($image_id);
		}	
	}else{
		$alt_text = esc_html__('Image Alt Text', 'dogri');
	}

	return $alt_text;
}





function dogri_facebook_share_url(){
	return 'https://www.facebook.com/sharer.php?u='.get_the_permalink().'&t=TEst';
}


function dogri_linkedin_share_url(){
	return 'https://www.linkedin.com/sharing/share-offsite/?url='.get_the_permalink();
}

function dogri_twitter_share_url(){
	return 'https://www.twitter.com/intent/tweet?url='.get_the_permalink().'&text='.get_the_excerpt();
}

function dogri_social_share(){
	$html = '';
	$html .= '<div class="social-share">';
	$html .= '<span class="social-share-title">'.esc_html__('share', 'dogri').'</span>';
	$html .= '<a target="_blank" class="facebook" href="https://www.facebook.com/sharer.php?u='.urlencode(get_the_permalink()).'&t=TEst" title="Share on Facebook"><i class="fab fa-facebook-f"></i></a>';
	$html .= '<a target="_blank" class="twitter" href="https://www.twitter.com/intent/tweet?url='.urlencode(get_the_permalink()).'&text='.urlencode(get_the_excerpt()).'" title="Tweet this"><i class="fab fa-twitter"></i></a>';
	$html .= '<a target="_blank" class="linkedin" href="https://www.linkedin.com/sharing/share-offsite/?url='.urlencode(get_the_permalink()).'"><i class="fab fa-linkedin"></i></a>';
	$html .= '<a target="_blank" class="pinterest" href="https://www.pinterest.com/sharing/share-offsite/?url='.urlencode(get_the_permalink()).'"><i class="fab fa-pinterest"></i></a>';
	$html .= '</div>';




	return $html;
}


// dogri_service_sidebar
function dogri_service_sidebar_func() {
	if(is_active_sidebar('tc-service-widget')){

		dynamic_sidebar( 'tc-service-widget');
	}
}
add_action('dogri_service_sidebar','dogri_service_sidebar_func',20);


// Block Styles
function dogri_register_block_styles() {

	if ( function_exists( 'register_block_style' ) ) {

		register_block_style(
			'core/image',
			array(
				'name'  => 'bottom-right',
				'label' => esc_html__( 'Bottom Right', 'dogri' ),
			)
		);
		
		register_block_style(
			'core/image',
			array(
				'name'  => 'bottom-left',
				'label' => esc_html__( 'Bottom Left', 'dogri' ),
			)
		);

		register_block_style(
			'core/image',
			array(
				'name'  => 'center',
				'label' => esc_html__( 'Center', 'dogri' ),
			)
		);
	}
}
add_action( 'after_setup_theme', 'dogri_register_block_styles' );


/**
 * Block Pattern
 */
function dogri_register_block_patterns() {
	if( function_exists('register_block_pattern')){
        register_block_pattern(
            'wpdocs/dogri-single-para',
            array(
                'title'         => __( 'Tiny Para', 'dogri' ),
                'description'   => _x( 'This is my first block pattern', 'Block pattern description', 'dogri' ),
                'content'       => '<!-- wp:paragraph --><p>A single paragraph block style</p><!-- /wp:paragraph -->',
                'categories'    => array( 'text' ),
                'keywords'      => array( 'cta', 'demo', 'example' ),
                'viewportWidth' => 800,
            )
        );
	}	
}
add_action( 'init', 'dogri_register_block_patterns' );

// header extra menu

function dogri_header_extra(){
	$header_contact_address             = get_theme_mod('dogri_header_contact_address', esc_html__( '12/A, Mirnada City Tower, NYC', 'dogri' ));
    $header_contact_email               = get_theme_mod('dogri_header_contact_email', esc_html__( 'support@mail.com', 'dogri' ));
    $header_contact_phone               = get_theme_mod('dogri_header_contact_phone', esc_html__('+088889797697', 'dogri'));

	$dogri_logo = get_template_directory_uri() . '/img/logo/logo-white.svg';
	$dogri_extra_logo = get_theme_mod('extra_logo', $dogri_logo);
	$dogri_extra_img = get_template_directory_uri() . '/img/resources/sidebar.png';
	$dogri_extra_sidebar_img = get_theme_mod('extra_sidebar_img', $dogri_extra_img);

    $dogri_extra_contact_info = get_theme_mod('dogri_extra_contact_info', esc_html__( 'Contact Info', 'dogri' ));
    $show_extra_contact_info               = get_theme_mod('dogri_extra_show_contact_info', false);
    $show_extra_social_profile               = get_theme_mod('dogri_extra_social_profile', false);

	$dogri_extra_subtitle = get_theme_mod('dogri_extra_subtitle', esc_html__( 'Contact Info', 'dogri' ));
	$dogri_extra_subtitle1 = get_theme_mod('dogri_extra_subtitle1', esc_html__( '#', 'dogri' ));
	$dogri_extra_subtitle2 = get_theme_mod('dogri_extra_subtitle2', esc_html__( 'Sat to Fri: 8:00am to 10pm', 'dogri' ));
	$dogri_extra_subtitle3 = get_theme_mod('dogri_extra_subtitle3', esc_html__( 'Get direction', 'dogri' ));


	ob_start(); ?>


  <!-- Offcanvas area start -->
  <div class="fix">
      <div class="offcanvas__info">
         <div class="offcanvas__wrapper">
            <div class="offcanvas__content">
               <div class="offcanvas__top mb-40 d-flex justify-content-between align-items-center">
                  <div class="offcanvas__logo">
				  <a href="<?php echo esc_url( home_url() ); ?>">
						<img src="<?php echo esc_url( $dogri_extra_logo ); ?>" alt="logo" />
					</a>
                  </div>
                  <div class="offcanvas__close">
                     <button>
                        <i class="fal fa-times"></i>
                     </button>
                  </div>
               </div>
               <div class="offcanvas__search mb-25">
			   		<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
						<input type="search" class="form-control" name="sidebar_search"
                            placeholder="<?php echo esc_attr_x( 'What are you searching for?', 'placeholder', 'dogri' ); ?>" value="<?php echo get_search_query(); ?>">
						<button type="submit"><?php echo _x( '<i class="far fa-search"></i>', 'submit button', 'dogri' ); ?></button>
                  	</form>
               </div>
			   <div class="mobile-menu fix mb-40"></div>
               <div class="offcanvas__contact mt-30 mb-20">
                  <h4><?php echo esc_html( $dogri_extra_contact_info ); ?></h4>
                  <ul>
                     <li class="d-flex align-items-center">
					 	<?php 
						if( $header_contact_address !== ""): ?>
                        <div class="offcanvas__contact-icon mr-15">
                           <i class="fal fa-map-marker-alt"></i>
                        </div>
                        <div class="offcanvas__contact-text">
                           <a href="#"><?php echo esc_html( $header_contact_address ); ?></a>
                        </div>
						<?php
						endif; ?>
                     </li>
                     <li class="d-flex align-items-center">
					 	<?php 
						if( $header_contact_phone !== ""): ?>
                        <div class="offcanvas__contact-icon mr-15">
                           <i class="fal fa-phone"></i>
                        </div>
                        <div class="offcanvas__contact-text">
							<a href="tel:<?php echo esc_attr( $header_contact_phone ); ?>"><?php echo esc_html( $header_contact_phone ); ?></a>
                        </div>
						<?php
						endif; ?>
                     </li>
                     <li class="d-flex align-items-center">
					 	<?php
						if( $header_contact_email !== "" ): ?>
                        <div class="offcanvas__contact-icon mr-15">
                           <i class="fal fa-envelope"></i>
                        </div>
                        <div class="offcanvas__contact-text">
						   <a href="mailto:<?php echo esc_attr( $header_contact_email ); ?>"><?php echo esc_html( $header_contact_email ); ?></a>
                        </div>
						<?php
						endif; ?>
                     </li>
                  </ul>
               </div>
               <div class="offcanvas__social">
				  <?php 
				if( $show_extra_social_profile === 1 ): ?>
					<ul>
						<?php dogri_header_social_profiles(); ?>
					</ul>
				<?php
				endif; ?>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="offcanvas__overlay"></div>
   <div class="offcanvas__overlay-white"></div>
   <!-- Offcanvas area start -->


	
	<?php return ob_get_clean();
}




function dogri_breadcrumb_page_title() {

	/**
	 * Filters the document title before it is generated.
	 *
	 * Passing a non-empty value will short-circuit dogri_breadcrumb_page_title(),
	 * returning that value instead.
	 *
	 * @since 4.4.0
	 *
	 * @param string $title The document title. Default empty string.
	 */
	$title = apply_filters( 'pre_get_document_title', '' );
	if ( ! empty( $title ) ) {
		return $title;
	}

	global $page, $paged;

	$title = array(
		'title' => '',
	);

	// If it's a 404 page, use a "Page not found" title.
	if ( is_404() ) {
		$title['title'] = __( 'Page not found', 'dogri' );

		// If it's a search, use a dynamic search results title.
	} elseif ( is_search() ) {
		/* translators: %s: Search query. */
		$title['title'] = sprintf( __( 'Search Results for &#8220;%s&#8221;', 'dogri' ), get_search_query() );

		// If on the front page, use the site title.
	} elseif ( is_front_page() ) {
		$title['title'] = get_bloginfo( 'name', 'display' );

		// If on a post type archive, use the post type archive title.
	} elseif ( is_post_type_archive() ) {
		$title['title'] = post_type_archive_title( '', false );

		// If on a taxonomy archive, use the term title.
	} elseif ( is_tax() ) {
		$title['title'] = single_term_title( '', false );

		/*
		* If we're on the blog page that is not the homepage
		* or a single post of any post type, use the post title.
		*/
	} elseif ( is_home() || is_singular() ) {
		$title['title'] = single_post_title( '', false );

		// If on a category or tag archive, use the term title.
	} elseif ( is_category() || is_tag() ) {
		$title['title'] = single_term_title( '', false );

		// If on an author archive, use the author's display name.
	} elseif ( is_author() && get_queried_object() ) {
		$author         = get_queried_object();
		$title['title'] = $author->display_name;

		// If it's a date archive, use the date as the title.
	} elseif ( is_year() ) {
		$title['title'] = get_the_date( _x( 'Y', 'yearly archives date format', 'dogri' ) );

	} elseif ( is_month() ) {
		$title['title'] = get_the_date( _x( 'F Y', 'monthly archives date format', 'dogri' ) );

	} elseif ( is_day() ) {
		$title['title'] = get_the_date();
	}

	// Add a page number if necessary.
	if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
		/* translators: %s: Page number. */
		$title['page'] = sprintf( __( 'Page %s', 'dogri' ), max( $paged, $page ) );
	}

	// Append the description or site title to give context.
	if ( is_front_page() ) {
		$title['tagline'] = get_bloginfo( 'description', 'display' );
	} else {
		$title['site'] = get_bloginfo( 'name', 'display' );
	}

	/**
	 * Filters the separator for the document title.
	 *
	 * @since 4.4.0
	 *
	 * @param string $sep Document title separator. Default '-'.
	 */
	$sep = apply_filters( 'document_title_separator', ':' );

	/**
	 * Filters the parts of the document title.
	 *
	 * @since 4.4.0
	 *
	 * @param array $title {
	 *     The document title parts.
	 *
	 *     @type string $title   Title of the viewed page.
	 *     @type string $page    Optional. Page number if paginated.
	 *     @type string $tagline Optional. Site description when on home page.
	 *     @type string $site    Optional. Site title when not on home page.
	 * }
	 */
	$title = apply_filters( 'document_title_parts', $title );

	$title = implode( " $sep ", array_filter( $title ) );

	/**
	 * Filters the document title.
	 *
	 * @since 5.8.0
	 *
	 * @param string $title Document title.
	 */
	$title = apply_filters( 'document_title', $title );

	return $title;
}


function dogri_page_title(){
	$title = dogri_breadcrumb_page_title();
	$titleArray = explode(':', $title);
	return trim( $titleArray[0]);
}