<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package dogri
 */
get_header();
?>

<?php
        $dogri_error_img = get_template_directory_uri() . '/img/icons/error.png';
		$dogri_error_404_text = get_theme_mod('dogri_error_404_text','404'); 
		$dogri_error_title = get_theme_mod('dogri_error_title','Page not found '); 
		$dogri_error_link_text = get_theme_mod('dogri_error_link_text','Back To Home '); 
		$dogri_error_desc = get_theme_mod('dogri_error_desc','Oops! The page you are looking for does not exist. It might have been moved or deleted. '); 
	?>

  <!-- Error area start -->
  <section class="error-area section-space">
         <div class="container">
            <div class="row justify-content-center">
               <div class="col-xxl-6 col-xl-6 col-md-6">
                  <div class="error-thumb w-img mb-50">
                     <img src="<?php echo esc_url($dogri_error_img); ?>" alt="<?php echo esc_attr('error-image','dogri'); ?>" />
                  </div>
                  <div class="error-content text-center">
                     <h2 class="section-title"><?php echo wp_kses_post( $dogri_error_title ); ?></h2>
                     <a href="<?php echo esc_url(home_url('/')); ?>" class="fill-btn">
                        <span class="fill-btn-inner">
                           <span class="fill-btn-normal"><?php echo wp_kses_post($dogri_error_link_text); ?><i class="fa-regular fa-angle-right"></i></span>
                           <span class="fill-btn-hover"><?php echo wp_kses_post($dogri_error_link_text); ?><i class="fa-regular fa-angle-right"></i></span>
                        </span>
                     </a>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Error area end -->



<?php
get_footer();