<?php
	/**
	 * Medodove Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Medodove/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'dogri_cta_widget');
	function dogri_cta_widget() {
		register_widget('dogri_cta_widget');
	}
	
	
	class Dogri_cta_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('dogri_cta_widget',esc_html__('Dogri Logo With Social Icons Widget','dogri-toolkit'),array(
				'description' => esc_html__('Dogri Logo With Social Icons Widget','dogri-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 


		?>

			<?php 
			if( $cta_style === 'style_1'): ?>
				<div class="footer-logo mb-35">
					<img src="<?php echo esc_url( $logo_url ); ?>" alt="image" />
				</div>
				
				<?php
				if( $title !== ""): ?>
					<p> <?php echo apply_filters( 'widget_title', $title ); ?></p>   
				<?php
				endif; ?>

				<div class="theme-social">
					<?php 
					if($facebook !== ""): ?>
						<a href="<?php print esc_url($facebook); ?>"><i class="fa-brands fa-facebook-f"></i></a>
					<?php 
					endif; ?>

					<?php 
					if($twitter !== ""): ?>
						<a href="<?php print esc_url($twitter); ?>"><i class="fa-brands fa-twitter"></i></a>
					<?php 
					endif; ?>

					<?php
					if($instagram !== ""): ?>
						<a href="<?php print esc_url($instagram); ?>"><i class="fa-brands fa-instagram"></i></a>
					<?php 
					endif; ?>

					<?php 
					
					if($pinterest !== "" ): ?>
						<a href="<?php print esc_url($pinterest); ?>"><i class="fa-brands fa-pinterest-p"></i></a>
					<?php
					endif; ?>
				</div>

				<?php 
				elseif( $cta_style === 'style_2' ): ?>				
				<?php
				if( $title !== ""): ?>
				<div class="footer-widget-title">
					<h4><?php echo apply_filters( 'widget_title', $title ); ?></h4>
				</div>
				<?php
				endif; ?>
				<div class="footer-payment-item">
					<div class="footer-payment-thumb">
						<img src="<?php echo esc_url( $logo_url ); ?>" alt="">
					</div>
				</div>
				<div class="footer-payment-item">
					<div class="footer-payment-thumb">
						<img src="<?php echo esc_url( $logo_white_url ); ?>" alt="">
					</div>
				</div>
				<div class="footer-payment-item">
					<div class="footer-payment-thumb">
						<img src="<?php echo esc_url( $logo_another_url ); ?>" alt="">
					</div>
				</div>			

				<?php
				endif; ?>
				

	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$cta_style  = isset($instance['cta_style'])? $instance['cta_style'] : 'style_1';
			$logo_url  = isset($instance['logo_url'])? $instance['logo_url']:'';
			$logo_white_url  = isset($instance['logo_white_url'])? $instance['logo_white_url']:'';
			$logo_another_url  = isset($instance['logo_another_url'])? $instance['logo_another_url']:'';
			$link_text  = isset($instance['link_text'])? $instance['link_text']:'';
			$link_url  = isset($instance['link_url'])? $instance['link_url']:'';
			$facebook  = isset($instance['facebook'])? $instance['facebook']:'';
			$twitter  = isset($instance['twitter'])? $instance['twitter']:'';
			$instagram  = isset($instance['instagram'])? $instance['instagram']:'';
			$pinterest  = isset($instance['pinterest'])? $instance['pinterest']:'';
			
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="<?php echo $this->get_field_id('cta_style'); ?>">Choose Style</label>
				<select name="<?php echo $this->get_field_name('cta_style'); ?>" id="<?php echo $this->get_field_id('cta_style'); ?>" class="widefat">
					<option value="" disabled="disabled">Select Style</option>
					<option value="style_1" <?php if($cta_style === 'style_1'){ echo 'selected="selected"'; } ?>>Style 1</option>
					<option value="style_2" <?php if($cta_style === 'style_2'){ echo 'selected="selected"'; } ?>>Style 2</option>
				</select>
			</p>

			<p>
				<label for="logo_url"><?php esc_html_e('Logo Url:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('logo_url')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('logo_url')); ?>" value="<?php print esc_attr($logo_url); ?>">

			<p>
				<label for="logo_white_url"><?php esc_html_e('Logo White Url:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('logo_white_url')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('logo_white_url')); ?>" value="<?php print esc_attr($logo_white_url); ?>">

			<p>
				<label for="logo_another_url"><?php esc_html_e('Logo Another Url:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('logo_another_url')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('logo_another_url')); ?>" value="<?php print esc_attr($logo_another_url); ?>">

			<p>
				<label for="link_text"><?php esc_html_e('Link Text:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('link_text')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('link_text')); ?>" value="<?php print esc_attr($link_text); ?>">

			<!-- <p>
				<label for="link_url"><?php esc_html_e('Link Url:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('link_url')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('link_url')); ?>" value="<?php print esc_attr($link_url); ?>"> -->


			<p>
				<label for="title"><?php esc_html_e('Facebook:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('facebook')); ?>"  name="<?php print esc_attr($this->get_field_name('facebook')); ?>" value="<?php print esc_attr($facebook); ?>">

			<p>
				<label for="title"><?php esc_html_e('Twitter:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('twitter')); ?>"  name="<?php print esc_attr($this->get_field_name('twitter')); ?>" value="<?php print esc_attr($twitter); ?>">


			<p>
				<label for="instagram"><?php esc_html_e('Instagram:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('instagram')); ?>"  name="<?php print esc_attr($this->get_field_name('instagram')); ?>" value="<?php print esc_attr($instagram); ?>">

			<p>
				<label for="pinterest"><?php esc_html_e('Pinterest:','dogri-toolkit'); ?></label>
			</p>
			<input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('pinterest')); ?>"  name="<?php print esc_attr($this->get_field_name('pinterest')); ?>" value="<?php print esc_attr($pinterest); ?>">
			


			
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['cta_style'] = ( ! empty( $new_instance['cta_style'] ) ) ? strip_tags( $new_instance['cta_style'] ) : '';
			$instance['logo_url'] = ( ! empty( $new_instance['logo_url'] ) ) ? strip_tags( $new_instance['logo_url'] ) : '';
			$instance['logo_white_url'] = ( ! empty( $new_instance['logo_white_url'] ) ) ? strip_tags( $new_instance['logo_white_url'] ) : '';
			$instance['logo_another_url'] = ( ! empty( $new_instance['logo_another_url'] ) ) ? strip_tags( $new_instance['logo_another_url'] ) : '';
			$instance['link_text'] = ( ! empty( $new_instance['link_text'] ) ) ? strip_tags( $new_instance['link_text'] ) : '';
			$instance['link_url'] = ( ! empty( $new_instance['link_url'] ) ) ? strip_tags( $new_instance['link_url'] ) : '';
			$instance['facebook'] = ( ! empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';
			$instance['twitter'] = ( ! empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';
			$instance['instagram'] = ( ! empty( $new_instance['instagram'] ) ) ? strip_tags( $new_instance['instagram'] ) : '';
			$instance['pinterest'] = ( ! empty( $new_instance['pinterest'] ) ) ? strip_tags( $new_instance['pinterest'] ) : '';

			
			return $instance;
		}
	}