<?php
	/**
	 * Medodove Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Medodove/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'dogri_cta_widget_2');
	function dogri_cta_widget_2() {
		register_widget('dogri_cta_widget_2');
	}
	
	
	class Dogri_Cta_Widget_2  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('dogri_cta_widget_2',esc_html__('Dogri CTA Top Widget Two','dogri-toolkit'),array(
				'description' => esc_html__('Dogri CTA Widget Two','dogri-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 


		?>


		<div class="widget-title">
			<h4><?php echo apply_filters( 'widget_title', $title ); ?></h4>
		</div>
		<div class="widget-content">
			<div class="footer-contact-widget">
				<p><?php echo apply_filters( 'widget_title', $title2 ); ?></p>
			</div>
			<ul class="footer-contact-widget-2">
				<li><a href="<?php echo esc_url( $link_url ); ?>"><?php echo esc_html( $link_text ); ?> </a></li>
				<li><a href="<?php echo esc_url( $link_url2 ); ?>"><?php echo esc_html( $link_text2 ); ?></a></li>
			</ul>
		</div>


	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$link_text  = isset($instance['link_text'])? $instance['link_text']:'';
			$link_url  = isset($instance['link_url'])? $instance['link_url']:'';

			$title2  = isset($instance['title2'])? $instance['title2']:'';
			$link_text2  = isset($instance['link_text2'])? $instance['link_text2']:'';
			$link_url2  = isset($instance['link_url2'])? $instance['link_url2']:'';
			
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">	
			
			<p>
				<label for="title2"><?php esc_html_e('Text:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title2')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title2')); ?>" value="<?php print esc_attr($title2); ?>">

			<p>
				<label for="link_text"><?php esc_html_e('Link Text:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('link_text')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('link_text')); ?>" value="<?php print esc_attr($link_text); ?>">

			<p>
				<label for="link_url"><?php esc_html_e('Link Url:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('link_url')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('link_url')); ?>" value="<?php print esc_attr($link_url); ?>">			
		

			<!-- 2nd -->
			

			<p>
				<label for="link_text2"><?php esc_html_e('Link Text Two:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('link_text2')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('link_text2')); ?>" value="<?php print esc_attr($link_text2); ?>">

			<p>
				<label for="link_url2"><?php esc_html_e('Link Url Two:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('link_url2')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('link_url2')); ?>" value="<?php print esc_attr($link_url2); ?>">
			


			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['logo_url'] = ( ! empty( $new_instance['logo_url'] ) ) ? strip_tags( $new_instance['logo_url'] ) : '';
			$instance['link_text'] = ( ! empty( $new_instance['link_text'] ) ) ? strip_tags( $new_instance['link_text'] ) : '';
			$instance['link_url'] = ( ! empty( $new_instance['link_url'] ) ) ? strip_tags( $new_instance['link_url'] ) : '';

			$instance['title2'] = ( ! empty( $new_instance['title2'] ) ) ? strip_tags( $new_instance['title2'] ) : '';
			$instance['link_text2'] = ( ! empty( $new_instance['link_text2'] ) ) ? strip_tags( $new_instance['link_text2'] ) : '';
			$instance['link_url2'] = ( ! empty( $new_instance['link_url2'] ) ) ? strip_tags( $new_instance['link_url2'] ) : '';

			
			return $instance;
		}
	}