<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Testimonial_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'testimonial_slider';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Slider', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'testimonial_slider',
			[
				'label' => esc_html__( 'Testimonial Slider', 'dogri-elementor' ),
			]
		);	

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'dogri-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'dogri-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'dogri-elementor' ),
					'style3'   => esc_html__( 'Style Three', 'dogri-elementor' ),
				),
			]
		);	
		
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your sub title', 'dogri-elementor' ),
			]
		);
		
	
		$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
				]
			);


			$this->add_control(
				'bgimg',
				[
					'label' => esc_html__('Background image', 'dogri-elementor'),
					'type' => Controls_Manager::MEDIA,
					'default' => ['url' => Utils::get_placeholder_image_src(),],
				]
			);	

			$this->add_control(
				'image',
					[
					  'label' => __( 'Image', 'dogri-elementor' ),
					  'type' => Controls_Manager::MEDIA,
					  'default' => ['url' => Utils::get_placeholder_image_src(),],
					]
			);	
			
			$this->add_control(
				'alt_text',
				[
					'label'       => __( 'Alt text', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter Your Description', 'dogri-elementor' ),
				]
			);



		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								
								'block_image' =>
								[
									'name' => 'block_image',
									'label' => __( 'Icon Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								  ],	

								  'block_alt_text' =>
								  [
								  'name' => 'block_alt_text',
								  'label' => esc_html__('Image Alt Text', 'dogri-elementor'),
								  'type' => Controls_Manager::TEXTAREA,
								  'default' => esc_html__('', 'dogri-elementor')
								  ],


								  'block_text' =>
								  [
									  'name' => 'block_text',
									  'label' => esc_html__('Text', 'dogri-elementor'),
									  'type' => Controls_Manager::TEXTAREA,
									  'default' => esc_html__('', 'dogri-elementor')
								  ],

								  'block_image1' =>
								[
									'name' => 'block_image1',
									'label' => __( 'Author Image', 'dogri-elementor' ),
									'type' => Controls_Manager::MEDIA,
									'default' => ['url' => Utils::get_placeholder_image_src(),],
								  ],	

								  'block_alt_text1' =>
								  [
								  'name' => 'block_alt_text1',
								  'label' => esc_html__('Image Alt Text', 'dogri-elementor'),
								  'type' => Controls_Manager::TEXTAREA,
								  'default' => esc_html__('', 'dogri-elementor')
								  ],


								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_btnlink' =>
								[
									'name' => 'block_btnlink',
									'label' => __( 'Title Url', 'dogri-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
									'show_external' => true,
									'default' => [
									  'url' => '',
									  'is_external' => true,
									  'nofollow' => true,
									],
								 ],

								 'block_subtitle' =>
								 [
									 'name' => 'block_subtitle',
									 'label' => esc_html__('Sub Title', 'dogri-elementor'),
									 'type' => Controls_Manager::TEXTAREA,
									 'default' => esc_html__('', 'dogri-elementor')
								 ],																
								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	


		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
	
		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .testimonial-area .section-subtitle span' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .testimonial-area .section-subtitle' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .testimonial-area .section-subtitle span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .testimonial-area .section-subtitle span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
		
			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .testimonial-area .section-subtitle span',
				'selector' => '{{WRAPPER}} .section-subtitle-5',
			)
		);
		
		
		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonial-area .section-subtitle span' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonial-area .section-subtitle span' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-5' => 'background-color: {{VALUE}} !important',
				),
			
			)
		); 

		$this->end_controls_section();		
		//End of  Sub Title 	==================	

		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .testimonial-area .section-title' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .testimonial-area .section-title' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .testimonial-area .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .testimonial-area .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title-3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .testimonial-area .section-title',
				'selector' => '{{WRAPPER}} .section-title-3',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .testimonial-area .section-title' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-title-3' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	


		    //Background Color ==========================

			$this->start_controls_section(
				'bg_color_block_settings',
				array(
					'label' => __( 'Background Color Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);			
		
			$this->add_control(
				'block_bg_color',
				array(
					'label'     => __( 'Section Background Color', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .testimonial-area' => 'background-color: {{VALUE}} !important',
					),
				)
			);
		
			$this->add_control(
				'block_bg_color_1',
				array(
					'label'     => __( 'Card Background Color', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .testimonial-item' => 'background: {{VALUE}} !important',
						'{{WRAPPER}} .testimonial-item.style-2' => 'background: {{VALUE}} !important',
					),
				)
			);
		
			$this->end_controls_section();
		
			//End of Background Color  


			//Section Padding Block==========================
			$this->start_controls_section(
				'section_padding_settings',
				array(
					'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);
			
			$this->add_control(
				'block_margin',
				array(
					'label'     => __( 'Block Margin', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .testimonial-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					),
					'responsive' => true, // This enables responsive settings
				)
			);
	
			$this->add_control(
				'block_padding',
				array(
					'label'     => __( 'Block Padding', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .testimonial-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					),
					'responsive' => true, // This enables responsive settings
				)
			);
	
			$this->end_controls_section();
			//End of Section Padding Block 


			//Section Padding Block==========================
			$this->start_controls_section(
				'section_padding_settings',
				array(
					'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);
			
			$this->add_control(
				'block_margin',
				array(
					'label'     => __( 'Block Margin', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .testimonial-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					),
					'responsive' => true, // This enables responsive settings
				)
			);
	
			$this->add_control(
				'block_padding',
				array(
					'label'     => __( 'Block Padding', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .testimonial-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
					),
					'responsive' => true, // This enables responsive settings
				)
			);
	
			$this->end_controls_section();
			//End of Section Padding Block 

	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 

var team = new Swiper(".testimonial-active", {
	slidesPerView: 2,
	spaceBetween: 30,
	loop: true,
	roundLengths: true,
	autoplay: {
		delay: 3000,
	},
	navigation: {
		nextEl: ".testimonial-button-next",
		prevEl: ".testimonial-button-prev",
	},
	breakpoints: {
		"1400": {
			slidesPerView: 3,
		},
		"1200": {
			slidesPerView: 1,
		},
		"992": {
			slidesPerView: 1,
		},
		"768": {
			slidesPerView: 1,
		},
		"576": {
			slidesPerView: 1,
		},
		"0": {
			slidesPerView: 1,
		},
	},
});


var team = new Swiper(".testimonial-active-2", {
	slidesPerView: 1,
	spaceBetween: 30,
	loop: true,
	roundLengths: true,
	autoplay: {
		delay: 3000,
	},
	navigation: {
		nextEl: ".testimonial-button-next",
		prevEl: ".testimonial-button-prev",
	},
	breakpoints: {
		"1400": {
			slidesPerView: 1,
		},
		"1200": {
			slidesPerView: 1,
		},
		"992": {
			slidesPerView: 1,
		},
		"768": {
			slidesPerView: 1,
		},
		"576": {
			slidesPerView: 1,
		},
		"0": {
			slidesPerView: 1,
		},
	},
});

var team = new Swiper(".testimonial-active-3", {
	slidesPerView: 3,
	spaceBetween: 30,
	loop: true,
	roundLengths: true,
	autoplay: {
		delay: 3000,
	},
	pagination: {
		el: ".bd-swiper-dot",
		clickable: true,
	},
	navigation: {
		nextEl: ".testimonial-button-next",
		prevEl: ".testimonial-button-prev",
	},
	breakpoints: {
		"1400": {
			slidesPerView: 3,
		},
		"1200": {
			slidesPerView: 3,
		},
		"992": {
			slidesPerView: 2,
		},
		"768": {
			slidesPerView: 2,
		},
		"576": {
			slidesPerView: 1,
		},
		"0": {
			slidesPerView: 1,
		},
	},
});

//write code above the line 

  });
</script>';


?>

<?php  if ( 'style1' === $settings['style'] ) : ?>

      <!-- Testimonial area start -->
	<section class="testimonial-area section-space theme-bg-2 fix">
      <div class="container">
         <div class="row justify-content-center">
            <div class="section-title-wrapper text-center section-title-spacing">
               <div class="section-subtitle">
                  <span><?php echo $settings['subtitle'];?></span>
               </div>
               <h2 class="section-title"><?php echo $settings['title'];?></h2>
            </div>
         </div>
         <div class="row">
            <div class="col-xxl-12">
               <div class="testimonial-main p-relative">
                  <div class="swiper testimonial-active">
                     <div class="swiper-wrapper">
					 <?php foreach($settings['repeat'] as $item):?>
                        <div class="swiper-slide">
                           <div class="testimonial-item">
                              <div class="testimonial-icon">
							  <img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
                              </div>
                              <div class="testimonial-content">
                                 <p><?php echo wp_kses($item['block_text'], $allowed_tags);?></p>
                                 <div class="avatar-item">
                                    <div class="avatar-thumbnail">
										<img src="<?php echo wp_get_attachment_url($item['block_image1']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text1'], $allowed_tags);?>">
                                    </div>
                                    <div class="avatar-info">
                                       <h4 class="avatar-name"><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
                                       <span class="avatar-designation"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
						<?php endforeach; ?>
                     </div>
                  </div>
                  <!-- If we need navigation buttons -->
                  <div class="navigation__wrapprer text-center">
                     <div class="common-slider-navigation">
                        <button class="testimonial-button-prev"><i class="fa-regular fa-arrow-left"></i></button>
                        <button class="testimonial-button-next"><i class="fa-regular fa-arrow-right"></i></button>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </section>
   <!-- Testimonial area end -->

<?php  elseif ( 'style2' === $settings['style'] ) : ?>
   <!-- Testimonial area start -->
   <section class="testimonial-area section-space p-relative">
      <div class="testimonial-bg">
         <div class="testimonial-bg-thumb include-bg" data-background="<?php echo wp_get_attachment_url($settings['bgimg']['id']);?>"></div>
      </div>
      <div class="container">
         <div class="row gy-50 align-items-center">
            <div class="col-xxl-7 col-xl-7 col-lg-6">
               <div class="swiper testimonial-active-2">
                  <div class="swiper-wrapper">
				  <?php foreach($settings['repeat'] as $item):?>
                     <div class="swiper-slide">
                        <div class="testimonial-content-2">
                           <div class="testimonial-icon">
						   <img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
                           </div>
                           <p><?php echo wp_kses($item['block_text'], $allowed_tags);?></p>
                           <div class="testmonial-bottom">
                              <!-- If we need navigation buttons -->
                              <div class="common-slider-navigation is-white">
                                 <button class="testimonial-button-prev"><i
                                       class="fa-regular fa-arrow-left"></i></button>
                                 <button class="testimonial-button-next"><i
                                       class="fa-regular fa-arrow-right"></i></button>
                              </div>
                              <div class="avatar-item">
                                 <div class="avatar-info-2">
                                    <h4 class="avatar-name"><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
                                    <span><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
					 <?php endforeach; ?>
                  </div>
               </div>
            </div>
            <div class="col-xxl-5 col-xl-5 col-lg-6">
               <div class="testimonial-thumb-wrapper d-md-flex justify-content-lg-end">
                  <div class="testimonial-thumb">
				  	<img src="<?php echo wp_get_attachment_url($settings['image']['id']);?>" alt="<?php echo esc_attr($settings['alt_text']);?>"/>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </section>
   <!-- Testimonial area end -->
   <?php  elseif ( 'style3' === $settings['style'] ) : ?>

     <!-- Testimonial area start -->
	 <section class="testimonial-area section-space">
         <div class="container">
            <div class="row g-5 align-items-end section-title-space">
               <div class="col-xxl-5 co-xl-6 col-lg-6">
			   	<?php if($settings['title']): ?>
                  <div class="section-title-wrapper-4">
                     <span class="section-subtitle-5 mb-25"><?php echo $settings['subtitle'];?></span>
                     <h2 class="section-title-3"><?php echo $settings['title'];?></h2>
                  </div>
				<?php endif; ?>
               </div>
               <div class="col-xl-6 co-xl-6 col-lg-6">
                  <!-- If we need navigation buttons -->
                  <div class="common-slider-navigation d-flex justify-content-start justify-content-md-end">
                     <button class="testimonial-button-prev"><i class="fa-regular fa-arrow-left"></i></button>
                     <button class="testimonial-button-next"><i class="fa-regular fa-arrow-right"></i></button>
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col-xxl-12">
                  <div class="swiper testimonial-active-3">
                     <div class="swiper-wrapper">
					 	<?php foreach($settings['repeat'] as $item):?>
                        <div class="swiper-slide">
                           <div class="testimonial-item style-2">
                              <div class="testimonial-icon">
							  <img src="<?php echo wp_get_attachment_url($item['block_image']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text'], $allowed_tags);?>">
                              </div>
                              <div class="testimonial-content">
                                 <p><?php echo wp_kses($item['block_text'], $allowed_tags);?></p>
                                 <div class="avatar-item">
                                    <div class="avatar-thumbnail">
									<img src="<?php echo wp_get_attachment_url($item['block_image1']['id']);?>" alt="<?php echo wp_kses($item['block_alt_text1'], $allowed_tags);?>">
                                    </div>
                                    <div class="avatar-info">
									   <h4 class="avatar-name"><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_title'], $allowed_tags);?></a></h4>
                                    	<span class="avatar-designation"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
						<?php endforeach; ?>
                     </div>
                     <div class="testimonial-pagination text-center">
                        <div class="bd-swiper-dot"></div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Testimonial area end -->

	<?php endif ;?>	

             
		<?php 
	}


}