<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

?>

<div class="bmi-modal bmi-modal-no-close bmi-modal-not-allowed" id="restore-progress-modal">

  <div class="bmi-modal-wrapper no-hpad" style="max-width: 900px; max-width: min(900px, 80vw)">
    <div class="bmi-modal-content center">

      <div class="mm60 f30 bold black"><?php _e('Restoring in progress', 'backup-backup') ?></div>

      <div class="red-error-bg tml">
        <div class="red-warning mtl mbl f18">
          <?php _e('Do not close this window as long as the restoring process is ongoing', 'backup-backup'); ?>
        </div>
      </div>

      <div class="mm60 progress-bar-wrapper">

        <div class="progress-bar">
          <div class="progress-active-bar" style="width: 0%;"></div>
          <div class="progress-percentage" style="left: 0%;">0%</div>
        </div>

      </div>

      <div class="mm60 step-progress cf">
        <div class="left f16 medium">
          <?php _e('Step: ', 'backup-backup') ?>
          <span id="restore_current_step"><?php _e('Preparing restore process...', 'backup-backup') ?></span>
        </div>
      </div>

      <div class="mm60 live-log" id="restore-live-log-wrapper">

        <div class="log-wrapper">
          <pre></pre>
        </div>

        <div class="f16 semibold secondary hoverable pointer">
          <a href="<?php echo get_site_url(); ?>/?backup-migration=PROGRESS_LOGS&progress-id=latest_migration.log&backup-id=current&t=<?php echo time(); ?>&sk=<?php echo bmi_get_config('REQUEST:SECRET'); ?>"
             download="restoration_live_log.txt" class="nlink">
            <?php _e('Download live log', 'backup-backup') ?>
          </a>
        </div>

      </div>

    </div>
  </div>

</div>
