<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) {
    exit;
  }

?>

<div class="bmi-modal" id="logs-sharing-ask-modal">

  <div class="bmi-modal-wrapper no-hpad" style="max-width: 660px; max-width: min(660px, 80vw);">
    <a href="#" class="bmi-modal-close">×</a>
    <div class="bmi-modal-content">

      <div class="mm60 f26 medium black"><?php _e('Do you agree to share logs?', 'backup-backup') ?></div>
      <div class="prenotices">

        <div class="prenotice prenotic-1">
          <div class="text">
            <ul class="bmi-list-bullet">
              <li><?php _e('You will directly support development of the plugin.', 'backup-backup') ?></li>
              <li><?php _e('Shared logs and info will be securely stored at our servers.', 'backup-backup') ?></li>
              <li><?php _e('In case of error, we can provide you much better and quicker support.', 'backup-backup') ?></li>
              <li><?php _e('Shared logs can be viewed only by our support team and plugin developers.', 'backup-backup') ?></li>
            </ul>
          </div>
        </div>

      </div>
      <div class="mm60 center">
        <div class="cf bmi-ask-logs-btns">
          <div class="left bmi-btn-logs-cont">
            <a href="#" class="btn" id="share-logs-allowed">
              <div class="text text-center">
                <div class="f18 regular"><?php _e('Yes, I want to help! :)', 'backup-backup') ?></div>
              </div>
            </a>
          </div>
          <div class="right bmi-btn-logs-cont">
            <a href="#" class="btn" id="share-logs-not-allowed">
              <div class="text text-center">
                <div class="f18 regular"><?php _e('No!', 'backup-backup') ?></div>
              </div>
            </a>
          </div>
        </div>
        <div class="text-grey text-muted mtl f18 inline bmi-modal-underline-link" id="ignore-share-log-request-for-now">
          <?php _e('Ask me later, run the backup for now', 'backup-backup') ?>
        </div>
      </div>

    </div>
  </div>

</div>
