<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Benefit_Tab extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'benefit_tab';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Benefit Accordion', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'benefit_tab',
			[
				'label' => esc_html__( 'Benefit Tab', 'dogri-elementor' ),
			]
		);	

		$this->add_control(
			'style',
			[
				'label'   => esc_html__( 'Select Style', 'dogri-elementor' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1'   => esc_html__( 'Style One', 'dogri-elementor' ),
					'style2'   => esc_html__( 'Style Two', 'dogri-elementor' ),
				),
			]
		);
		
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your sub title', 'dogri-elementor' ),
			]
		);
		
	
		$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
				]
			);
	
			$this->add_control(
				'text',
				[
					'label'       => __( 'Description Text', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter Your Description', 'dogri-elementor' ),
				]
			);
			
		$this->add_control(
			'bttn',
			[
				'label'       => __( 'Button', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Enter your Button Title', 'dogri-elementor' ),
				'default' => esc_html__('Read More', 'dogri-elementor'),
			]
		);	


		$this->add_control(
				'btnlink',
				[
				'label' => __( 'Button Url', 'dogri-elementor' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				
			]
			);

			$this->add_control(
				'image',
					[
					  'label' => __( 'Image', 'dogri-elementor' ),
					  'type' => Controls_Manager::MEDIA,
					  'default' => ['url' => Utils::get_placeholder_image_src(),],
					]
			);	
			
			$this->add_control(
				'alt_text',
				[
					'label'       => __( 'Alt text', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter Your Description', 'dogri-elementor' ),
				]
			);


			$this->add_control(
				'btnlink1',
				[
				'label' => __( 'Phone Url', 'dogri-elementor' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				
			]
			);

			$this->add_control(
				'subtitle1',
				[
					'label'       => __( 'Phone', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your sub title', 'dogri-elementor' ),
				]
			);



		$this->end_controls_section();
		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[						
								
								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								 'block_subtitle' =>
								 [
									 'name' => 'block_subtitle',
									 'label' => esc_html__('Sub Title', 'dogri-elementor'),
									 'type' => Controls_Manager::TEXTAREA,
									 'default' => esc_html__('', 'dogri-elementor')
								 ],

								 'block_text' =>
								 [
									'name' => 'block_text',
									'label' => esc_html__('Text', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
																
								
							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	


		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
	
		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .benefit-area .section-subtitle-2' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-2' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .benefit-area .section-subtitle-2' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-2' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .benefit-area .section-subtitle-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .benefit-area .section-subtitle-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
			'{{WRAPPER}} .section-subtitle-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
		
			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .benefit-area .section-subtitle-2',
				'selector' => '{{WRAPPER}} .section-subtitle-2',
			)
		);
		
		
		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .benefit-area .section-subtitle-2' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-2' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .benefit-area .section-subtitle-2' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .section-subtitle-2' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


		// Section Title 	==================    
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .benefit-area .section-title' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .section-title' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .benefit-area .section-title' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .section-title' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .benefit-area .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .benefit-area .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .benefit-area .section-title',
				'selector' => '{{WRAPPER}} .section-title',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .benefit-area .section-title' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .section-title' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	

		//Section Title Text==========================
		$this->start_controls_section(
			'section_title_text_settings',
			array(
				'label' => __( 'Section Title Text Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
		
		$this->add_control(
			'show_section_title_text',
			array(
				'label' => esc_html__( 'Show Section Title Text', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .benefit-content-wrap p' => 'display: {{VALUE}} !important',
					'{{WRAPPER}} .faq__content p' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_title_text_alingment',
			array(
				'label' => esc_html__( 'Section Title Text Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'toggle' => true,
				'selectors' => array(
					'{{WRAPPER}} .benefit-content-wrap p' => 'text-align: {{VALUE}} !important',
					'{{WRAPPER}} .faq__content p' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_text_margin',
			array(
				'label'     => __( 'Section Text Margin', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .benefit-content-wrap p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .faq__content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		); 
		
		$this->add_control(
			'section_title_text_padding',
			array(
				'label'     => __( 'Section Text Padding', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .benefit-content-wrap p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					'{{WRAPPER}} .faq__content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_text_typography',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .benefit-content-wrap p',
				'selector' => '{{WRAPPER}} .faq__content p',
			)
		);
		
		$this->add_control(
			'section_title_text_color',
			array(
				'label'     => __( 'Section Text Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .benefit-content-wrap p' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .faq__content p' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();
		//End of Section Title Text=========	


		
	//========== Button with Background ===================================

	$this->start_controls_section(
		'button_control',
		array(
			'label' => __( 'Button Settings', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'show_button',
		array(
			'label' => esc_html__( 'Show Button', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .benefit-content-wrap .fill-btn' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .fill-btn' => 'display: {{VALUE}} !important',
			),
		)
	);		
	$this->add_control(
		'button_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'condition'    => array( 'show_button' => 'show' ),
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'left',
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}} .benefit-content-wrap .fill-btn' => 'text-align: {{VALUE}} !important',
				'{{WRAPPER}} .fill-btn' => 'text-align: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_color',
		array(
			'label'     => __( 'Button Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .benefit-content-wrap .fill-btn' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .fill-btn' => 'color: {{VALUE}} !important',

			),
		)
	);
	$this->add_control(
		'button_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .benefit-content-wrap .fill-btn' => 'background: {{VALUE}} !important',
				'{{WRAPPER}} .fill-btn' => 'background: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .benefit-content-wrap .fill-btn:before' => 'background: {{VALUE}} !important',
				'{{WRAPPER}} .fill-btn:before' => 'background: {{VALUE}} !important',
			),
		)
	);				
	$this->add_control(
		'button_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .benefit-content-wrap .fill-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .fill-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'button_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
			'selectors' => array(
				'{{WRAPPER}} .benefit-content-wrap .fill-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .fill-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'button_typography',
			'condition'    => array( 'show_button' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .benefit-content-wrap .fill-btn',
			'selector' => '{{WRAPPER}} .fill-btn',
		)
	);
	$this->add_group_control(
		\Elementor\Group_Control_Border::get_type(),
		array(
			'name' => 'border',
			'condition'    => array( 'show_button' => 'show' ),
			'selector' => '{{WRAPPER}} .benefit-content-wrap .fill-btn',
			'selector' => '{{WRAPPER}} .fill-btn',
		)
	);
	$this->add_control(
		'border_radius',
		array(
			'label' => esc_html__( 'Border Radius', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' => [ 'px', '%' ],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 1000,
					'step' => 5,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 50,
			],
			'selectors' => [
				'{{WRAPPER}} .benefit-content-wrap .fill-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .fill-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		)
	);

	$this->end_controls_section();

	//End of Button	


	// Title 	==================	


	$this->start_controls_section(
		'title_settings',
		array(
			'label' => __( 'Title Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
			
	$this->add_control(
		'show_title',
		array(
			'label' => esc_html__( 'Show Title', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .bd-faq .accordion-button' => 'display: {{VALUE}} !important',
				'{{WRAPPER}} .accordion-header' => 'display: {{VALUE}} !important',
			),   
		)
	);
	
	$this->add_control(
		'title_alignment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_title' => 'show' ),
			'toggle' => true,
			'selectors' => array(
			
				'{{WRAPPER}} .bd-faq .accordion-button' => 'text-align: {{VALUE}}',
				'{{WRAPPER}} .accordion-header' => 'text-align: {{VALUE}}',
			),
		)
	);
	
	$this->add_control(
		'title_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .bd-faq .accordion-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .accordion-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'title_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .bd-faq .accordion-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				'{{WRAPPER}} .accordion-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'title_typography',
			'condition'    => array( 'show_title' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .bd-faq .accordion-button',
			'selector' => '{{WRAPPER}} .accordion-header',
		)
	);
	
	$this->add_control(
		'title_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .bd-faq .accordion-button' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .accordion-header' => 'color: {{VALUE}} !important',
	
			),
		)
	);

	$this->add_control(
		'title_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .bd-faq .accordion-button:hover' => 'color: {{VALUE}} !important',
				'{{WRAPPER}} .accordion-header:hover' => 'color: {{VALUE}} !important',
	
			),
		)
	);

	$this->end_controls_section();	
	
	
	//End of  Title 	==================


	//Section Padding Block==========================
	$this->start_controls_section(
		'section_padding_settings',
		array(
			'label' => __( 'Section Padding Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'block_margin',
		array(
			'label'     => __( 'Block Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .benefit-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->add_control(
		'block_padding',
		array(
			'label'     => __( 'Block Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .benefit-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
			),
			'responsive' => true, // This enables responsive settings
		)
	);

	$this->end_controls_section();
	//End of Section Padding Block 


	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		$sentence = wp_kses_post( preg_replace('/[^a-zA-Z0-9_ -]/s',' ', 'subtitle') );
		$sentence .= 'faq-';
		$faq_id = str_replace(' ', '', strtolower($sentence));
		$faq_id .= mt_rand();
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 


//write code above the line 

  });
</script>';


?>

<?php  if ( 'style1' === $settings['style'] ) : ?>
      <!-- benefit area start -->
	<section class="benefit-area section-space">
      <div class="container">
         <div class="row gy-50 wow fadeInUp" data-wow-delay=".3s">
            <div class="col-xxl-6 col-xl-6 col-lg-6">
               <div class="benefit-content-wrap bd-sticky">
                  <div class="section-title-wrapper-2 mb-15">
                     <span class="section-subtitle-2 mb-25"><?php echo $settings['subtitle'];?></span>
                     <h2 class="section-title"><?php echo $settings['title'];?></h2>
                  </div>
                  <p><?php echo $settings['text'];?></p>
                  <div class="button-wrapper mt-45">
                     <a href="<?php echo esc_url($settings['btnlink']['url']);?>" class="fill-btn">
                        <span class="fill-btn-inner">
                           <span class="fill-btn-normal"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
                           <span class="fill-btn-hover"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
                        </span>
                     </a>
                     <div class="link-text">
                        <span><img src="<?php echo wp_get_attachment_url($settings['image']['id']);?>" alt="<?php echo esc_attr($settings['alt_text']);?>"/></span>
                        <a href="<?php echo esc_url($settings['btnlink1']['url']);?>"><?php echo $settings['subtitle1'];?></a>
                     </div>
                  </div>
               </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6">
               <div class="faq-wrapper">
                  <div class="bd-faq">
                     <div class="accordion" id="accordionExample-st-2<?php print esc_attr( $faq_id ); ?>">
                        <div class="bd-faq-group">

							<?php 
							foreach ( $settings['repeat'] as $key => $item ) :
								$active_class = ($key == 0 ) ? '' : 'collapsed';
								$show = ($key == 0 ) ? 'show' : '';
								?>
                           <div class="accordion-item">
                              <h2 class="accordion-header" id="heading<?php print esc_attr($item['_id']); ?>-st-2">
                                 <button class="accordion-button <?php echo esc_attr( $active_class ); ?>" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse<?php print esc_attr($item['_id']); ?>-st-2" aria-expanded="true"
                                    aria-controls="collapse<?php print esc_attr($item['_id']); ?>-st-2">
                                    <span class="accordion-number"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></span>
                                    <?php echo wp_kses($item['block_title'], $allowed_tags);?>
                                 </button>
                              </h2>
                              <div id="collapse<?php print esc_attr($item['_id']); ?>-st-2" class="accordion-collapse collapse <?php print esc_attr($show); ?>"
                                 aria-labelledby="heading<?php print esc_attr($item['_id']); ?>-st-2" data-bs-parent="#accordionExample-st-2<?php print esc_attr( $faq_id ); ?>">
                                 <div class="accordion-body">
								 	<?php echo wp_kses($item['block_text'], $allowed_tags);?>
                                 </div>
                              </div>
                           </div>
						   <?php endforeach; ?>

                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </section>
   <!-- benefit area end -->
<?php  elseif ( 'style2' === $settings['style'] ) : ?>
   <!-- FAQ area start -->
   <section class="faq__area section-space">
         <div class="container">
            <div class="row gy-50 wow fadeInUp" data-wow-delay=".3s">
               <div class="col-xxl-5 col-xl-5 col-lg-6">
                  <div class="faq__content bd-sticky">
                     <div class="section-title-wrapper-2 mb-15">
                        <span class="section-subtitle-2 mb-25"><?php echo $settings['subtitle'];?></span>
                        <h2 class="section-title"><?php echo $settings['title'];?></h2>
                     </div>
                     <p class="mb-40"><?php echo $settings['text'];?></p>
                     <a href="<?php echo esc_url($settings['btnlink']['url']);?>" class="fill-btn">
                        <span class="fill-btn-inner">
                           <span class="fill-btn-normal"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
                           <span class="fill-btn-hover"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
                        </span>
                     </a>
                  </div>
               </div>
               <div class="col-xxl-7 col-xl-7 col-lg-6">
                  <div class="bd__faq">
				  <?php 
					foreach ( $settings['repeat'] as $key => $item ) :
						$active_class = ($key == 0 ) ? '' : 'collapsed';
						$show = ($key == 0 ) ? 'show' : '';
						?>
					<div class="accordion-item">
						<h2 class="accordion-header" id="heading<?php print esc_attr($item['_id']); ?>-st-2">
							<button class="accordion-button <?php echo esc_attr( $active_class ); ?>" type="button" data-bs-toggle="collapse"
							data-bs-target="#collapse<?php print esc_attr($item['_id']); ?>-st-2" aria-expanded="true"
							aria-controls="collapse<?php print esc_attr($item['_id']); ?>-st-2">
							
							<?php echo wp_kses($item['block_title'], $allowed_tags);?>
							</button>
						</h2>
						<div id="collapse<?php print esc_attr($item['_id']); ?>-st-2" class="accordion-collapse collapse <?php print esc_attr($show); ?>"
							aria-labelledby="heading<?php print esc_attr($item['_id']); ?>-st-2" data-bs-parent="#accordionExample-st-2<?php print esc_attr( $faq_id ); ?>">
							<div class="accordion-body">
							<?php echo wp_kses($item['block_text'], $allowed_tags);?>
							</div>
						</div>
					</div>
					<?php endforeach; ?>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- FAQ area end -->
<?php endif ;?>	



             
		<?php 
	}


}