<?php 
/** 
 * [custom_post_metabox description]
 * @return [type] [description]
 */
function custom_post_metabox() {
  
  $page = new_cmb2_box(array(
    'id'  => 'dogri-toolkit',
    'title' =>  esc_html__( 'Page Info', 'dogri-toolkit' ),
    'object_types'  => array('page'),
    'fields'       => array (

        array (
            'name' => esc_html__( 'Breadcrumb Style', 'dogri-toolkit' ),
            'id' => 'dogri_choice_breadcrumb_style',
            'type' => 'select',
            'show_option_none' => false,
            'options' => array(
                'default' => esc_html__( 'Default', 'dogri-toolkit' ),
                'breadcrumb-style-1' => esc_html__( 'Breadcrumb Style 1', 'dogri-toolkit' ),
                'breadcrumb-style-2' => esc_html__( 'Breadcrumb Style 2', 'dogri-toolkit' )
            ),
        ),
        array(
          'name' => esc_html__( 'Is it invisible breadcrumb?', 'dogri-toolkit'),
          'id'   => 'dogri_invisible_breadcrumb',
          'type' => 'checkbox',
        ),
        array(
            'name' => esc_html__( 'Breadcrumb Background', 'dogri-toolkit'),
            'id'   => 'breadcrumb_bg_img_from_page',
            'type' => 'file',
            'desc'    => 'Upload an image or enter an URL.',
        ),
        array(
          'name' => esc_html__( 'Hide Breadcrumb Background Image', 'dogri-toolkit'),
          'id'   => 'hide_breadcrumb_bg_img',
          'type' => 'checkbox',
        ),
        // shape-1
        // array(
        //   'name' => esc_html__( 'Breadcrumb Background Shape 1', 'dogri-toolkit'),
        //   'id'   => 'breadcrumb_bg_img_from_page_shape_1',
        //   'type' => 'file',
        //   'desc'    => 'Upload an image or enter an URL.',
        // ),
        // array(
        //   'name' => esc_html__( 'Hide Breadcrumb Background Shape 1', 'dogri-toolkit'),
        //   'id'   => 'hide_breadcrumb_bg_img_shape_1',
        //   'type' => 'checkbox',
        // ),
         // shape-2
        //  array(
        //   'name' => esc_html__( 'Breadcrumb Background Shape 2', 'dogri-toolkit'),
        //   'id'   => 'breadcrumb_bg_img_from_page_shape_2',
        //   'type' => 'file',
        //   'desc'    => 'Upload an image or enter an URL.',
        // ),
        // array(
        //   'name' => esc_html__( 'Hide Breadcrumb Background Shape 2', 'dogri-toolkit'),
        //   'id'   => 'hide_breadcrumb_bg_img_shape_2',
        //   'type' => 'checkbox',
        // ),
        // array(
        //   'name' => esc_html__( 'Breadcrumb Sub Title', 'dogri-toolkit'),
        //   'id'   => 'breadcrumb_sub_title_from_page',
        //   'type' => 'text',
        // ),
        // array(
        //   'name' => esc_html__( 'Button Text', 'dogri-toolkit'),
        //   'id'   => 'button_text_from_page',
        //   'type' => 'text',
        // ),
        // array(
        //   'name' => esc_html__( 'Button Url', 'dogri-toolkit'),
        //   'id'   => 'button_url_from_page',
        //   'type' => 'text',
        // ),
        array(
          'name' => esc_html__( 'Enable Secondary Logo', 'dogri-toolkit'),
          'id'   => 'dogri_enable_sec_logo',
          'type' => 'checkbox',
        ),
        array (
            'name' => esc_html__( 'Header Style', 'dogri-toolkit' ),
            'id' => 'dogri_choice_header_style',
            'type' => 'select',
            'show_option_none' => false,
            'options' => array(
                'default' => esc_html__( 'Default', 'dogri-toolkit' ),
                'header-style-1' => esc_html__( 'Header Style 1', 'dogri-toolkit' ),
                'header-style-2' => esc_html__( 'Header Style 2', 'dogri-toolkit' ),
                'header-style-3' => esc_html__( 'Header Style 3', 'dogri-toolkit' ),
                'header-style-4' => esc_html__( 'Header Style 4', 'dogri-toolkit' ),
                'header-style-5' => esc_html__( 'Header Style 5', 'dogri-toolkit' ),
            ),
        ),
        array (
            'name' => esc_html__( 'Footer Style', 'dogri-toolkit' ),
            'id' => 'dogri_choice_footer_style',
            'type' => 'select',
            'show_option_none' => false,
            'options' => array(
                'default' => esc_html__( 'Default', 'dogri-toolkit' ),
                'footer-style-1' => esc_html__( 'Footer Style 1', 'dogri-toolkit' ),
                'footer-style-2' => esc_html__( 'Footer Style 2', 'dogri-toolkit' ),
                'footer-style-3' => esc_html__( 'Footer Style 3', 'dogri-toolkit' ),
                'footer-style-4' => esc_html__( 'Footer Style 4', 'dogri-toolkit' ),
            ),
        ),
        // array(
        //     'name' => esc_html__( 'Footer Background', 'dogri-toolkit'),
        //     'id'   => 'dogri_footer_bg',
        //     'type' => 'file',
        //     'desc'    => 'Upload an image or enter an URL.',
        // ),
        // array(
        //     'name' => esc_html__( 'Footer Background Color', 'dogri-toolkit'),
        //     'id'   => 'dogri_footer_bg_color',
        //     'type' => 'colorpicker',
        //     'desc'    => 'Choose Color From Here',
        // ),
    ) 
  ));

}

add_action('cmb2_admin_init', 'custom_post_metabox');


/**
 * [dogri_profile_metabox description]
 * @param  array  $review [description]
 * @return [type]         [description]
 */
function dogri_profile_metabox(array $profile) {

  $profile[] = array(
    'id'           => 'profile-edit',
    'title'        => esc_html__( 'Profile Media links', 'dogri-toolkit' ),
    'object_types' => array( 'user'),
    'fields'       => array (
      array(
        'name' => esc_html__( 'Facebook Url', 'dogri-toolkit'),
        'id'   => 'profile_fb_url',
        'type' => 'text_url',
      ),
      array(
        'name' => esc_html__( 'Twitter Url', 'dogri-toolkit'),
        'id'   => 'profile_twitter_url',
        'type' => 'text_url',
      ),
      array(
        'name' => esc_html__( 'Google Plus Url', 'dogri-toolkit'),
        'id'   => 'profile_google_url',
        'type' => 'text_url',
      ),
      array(
        'name' => esc_html__( 'Instagram Url', 'dogri-toolkit'),
        'id'   => 'profile_instagram_url',
        'type' => 'text_url',
      )

    )
  );

  return $profile;
}

add_filter('cmb2_meta_boxes','dogri_profile_metabox');




function dogri_metabox_for_blog(){


  $section = new_cmb2_box(array(
    'title'     => 'Fields According to Post Format',
    'object_types'  => array('post'),
    'id'      => 'fields-for-posts'
  ));


  $section->add_field(array(
    'name'  => 'Video URL',
    'id'  => '_video-url',
    'type'  => 'oembed'
  ));

  $section->add_field(array(
    'name'  => 'Audio URL',
    'id'  => '_audio-url',
    'type'  => 'oembed'
  ));

  $section->add_field(array(
    'name'  => 'Gallery Images',
    'id'  => '_gallery-images',
    'type'  => 'file_list'
  ));

}
add_action('cmb2_admin_init', 'dogri_metabox_for_blog');



function dogri_metabox_for_massionary_blog(){


  $section = new_cmb2_box(array(
    'title'     => 'Massionary blog',
    'object_types'  => array('post'),
    'id'      => 'fields-for-massionary-blog-posts'
  ));


  $section->add_field(array(
    'name'  => 'Full Featured Image',
    'id'  => 'featured_blog_image',
    'type'  => 'file'
  ));

}
add_action('cmb2_admin_init', 'dogri_metabox_for_massionary_blog');
